/*
 * Decompiled with CFR 0.152.
 */
package com.netease.cloud.auth;

import com.netease.cloud.ClientException;
import com.netease.cloud.auth.BasicCredentials;
import com.netease.cloud.auth.Credentials;
import com.netease.cloud.auth.SigningAlgorithm;
import com.netease.cloud.auth.StringSigner;
import java.io.UnsupportedEncodingException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public abstract class AbstractStringSigner
implements StringSigner {
    private static final String DEFAULT_ENCODING = "UTF-8";

    protected String signAndBase64Encode(String data, String key, SigningAlgorithm algorithm) throws ClientException {
        try {
            return this.signAndBase64Encode(data.getBytes(DEFAULT_ENCODING), key, algorithm);
        }
        catch (UnsupportedEncodingException e) {
            throw new ClientException("Unable to calculate a request signature: " + e.getMessage(), e);
        }
    }

    protected String signAndBase64Encode(byte[] data, String key, SigningAlgorithm algorithm) throws ClientException {
        try {
            byte[] signature = this.sign(data, key.getBytes(DEFAULT_ENCODING), algorithm);
            return new String(Base64.encodeBase64((byte[])signature));
        }
        catch (Exception e) {
            throw new ClientException("Unable to calculate a request signature: " + e.getMessage(), e);
        }
    }

    protected byte[] sign(String stringData, byte[] key, SigningAlgorithm algorithm) throws ClientException {
        try {
            byte[] data = stringData.getBytes(DEFAULT_ENCODING);
            return this.sign(data, key, algorithm);
        }
        catch (Exception e) {
            throw new ClientException("Unable to calculate a request signature: " + e.getMessage(), e);
        }
    }

    protected byte[] sign(byte[] data, byte[] key, SigningAlgorithm algorithm) throws ClientException {
        try {
            Mac mac = Mac.getInstance(algorithm.toString());
            mac.init(new SecretKeySpec(key, algorithm.toString()));
            return mac.doFinal(data);
        }
        catch (Exception e) {
            throw new ClientException("Unable to calculate a request signature: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Credentials sanitizeCredentials(Credentials credentials) {
        String accessKeyId = null;
        String secretKey = null;
        Credentials credentials2 = credentials;
        synchronized (credentials2) {
            accessKeyId = credentials.getAccessKeyId();
            secretKey = credentials.getSecretKey();
        }
        if (secretKey != null) {
            secretKey = secretKey.trim();
        }
        if (accessKeyId != null) {
            accessKeyId = accessKeyId.trim();
        }
        return new BasicCredentials(accessKeyId, secretKey);
    }
}

