/*
 * Decompiled with CFR 0.152.
 */
package com.netease.cloud;

import com.netease.cloud.ClientConfiguration;
import com.netease.cloud.handlers.RequestHandler;
import com.netease.cloud.http.ExecutionContext;
import com.netease.cloud.http.NeteaseHttpClient;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public abstract class WebServiceClient {
    protected URI endpoint;
    protected ClientConfiguration clientConfiguration;
    protected NeteaseHttpClient client;
    protected final List<RequestHandler> requestHandlers;

    public WebServiceClient(ClientConfiguration clientConfiguration) {
        this.clientConfiguration = clientConfiguration;
        this.client = new NeteaseHttpClient(clientConfiguration);
        this.requestHandlers = Collections.synchronizedList(new LinkedList());
    }

    public void setEndpoint(String endpoint) throws IllegalArgumentException {
        if (!endpoint.contains("://")) {
            endpoint = this.clientConfiguration.getProtocol().toString() + "://" + endpoint;
        }
        try {
            this.endpoint = new URI(endpoint);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void setConfiguration(ClientConfiguration clientConfiguration) {
        this.clientConfiguration = clientConfiguration;
        this.client = new NeteaseHttpClient(clientConfiguration);
    }

    public void shutdown() {
        this.client.shutdown();
    }

    public void addRequestHandler(RequestHandler requestHandler) {
        this.requestHandlers.add(requestHandler);
    }

    public void removeRequestHandler(RequestHandler requestHandler) {
        this.requestHandlers.remove(requestHandler);
    }

    protected ExecutionContext createExecutionContext() {
        ExecutionContext executionContext = new ExecutionContext(this.requestHandlers);
        return executionContext;
    }
}

