/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.api.impl;

import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.reflect.TypeToken;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.api.WxCpUserService;
import me.chanjar.weixin.cp.bean.WxCpInviteResult;
import me.chanjar.weixin.cp.bean.WxCpUser;
import me.chanjar.weixin.cp.bean.WxCpUserExternalContactInfo;
import me.chanjar.weixin.cp.util.json.WxCpGsonBuilder;

public class WxCpUserServiceImpl
implements WxCpUserService {
    private final WxCpService mainService;

    @Override
    public void authenticate(String userId) throws WxErrorException {
        this.mainService.get(this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/user/authsucc?userid=" + userId), null);
    }

    @Override
    public void create(WxCpUser user) throws WxErrorException {
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/user/create");
        this.mainService.post(url, user.toJson());
    }

    @Override
    public void update(WxCpUser user) throws WxErrorException {
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/user/update");
        this.mainService.post(url, user.toJson());
    }

    @Override
    public void delete(String ... userIds) throws WxErrorException {
        if (userIds.length == 1) {
            String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/user/delete?userid=" + userIds[0]);
            this.mainService.get(url, null);
            return;
        }
        JsonObject jsonObject = new JsonObject();
        JsonArray jsonArray = new JsonArray();
        for (String userId : userIds) {
            jsonArray.add((JsonElement)new JsonPrimitive(userId));
        }
        jsonObject.add("useridlist", (JsonElement)jsonArray);
        this.mainService.post("/cgi-bin/user/batchdelete", jsonObject.toString());
    }

    @Override
    public WxCpUser getById(String userid) throws WxErrorException {
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/user/get?userid=" + userid);
        String responseContent = this.mainService.get(url, null);
        return WxCpUser.fromJson(responseContent);
    }

    @Override
    public List<WxCpUser> listByDepartment(Long departId, Boolean fetchChild, Integer status) throws WxErrorException {
        String params = "";
        if (fetchChild != null) {
            params = params + "&fetch_child=" + (fetchChild != false ? "1" : "0");
        }
        params = status != null ? params + "&status=" + status : params + "&status=0";
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/user/list?department_id=" + departId);
        String responseContent = this.mainService.get(url, params);
        JsonElement tmpJsonElement = new JsonParser().parse(responseContent);
        return (List)WxCpGsonBuilder.create().fromJson(tmpJsonElement.getAsJsonObject().get("userlist"), new TypeToken<List<WxCpUser>>(){}.getType());
    }

    @Override
    public List<WxCpUser> listSimpleByDepartment(Long departId, Boolean fetchChild, Integer status) throws WxErrorException {
        String params = "";
        if (fetchChild != null) {
            params = params + "&fetch_child=" + (fetchChild != false ? "1" : "0");
        }
        params = status != null ? params + "&status=" + status : params + "&status=0";
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/user/simplelist?department_id=" + departId);
        String responseContent = this.mainService.get(url, params);
        JsonElement tmpJsonElement = new JsonParser().parse(responseContent);
        return (List)WxCpGsonBuilder.create().fromJson(tmpJsonElement.getAsJsonObject().get("userlist"), new TypeToken<List<WxCpUser>>(){}.getType());
    }

    @Override
    public WxCpInviteResult invite(List<String> userIds, List<String> partyIds, List<String> tagIds) throws WxErrorException {
        JsonArray jsonArray;
        JsonObject jsonObject = new JsonObject();
        if (userIds != null) {
            jsonArray = new JsonArray();
            for (String userId : userIds) {
                jsonArray.add((JsonElement)new JsonPrimitive(userId));
            }
            jsonObject.add("user", (JsonElement)jsonArray);
        }
        if (partyIds != null) {
            jsonArray = new JsonArray();
            for (String userId : partyIds) {
                jsonArray.add((JsonElement)new JsonPrimitive(userId));
            }
            jsonObject.add("party", (JsonElement)jsonArray);
        }
        if (tagIds != null) {
            jsonArray = new JsonArray();
            for (String tagId : tagIds) {
                jsonArray.add((JsonElement)new JsonPrimitive(tagId));
            }
            jsonObject.add("tag", (JsonElement)jsonArray);
        }
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/batch/invite");
        return WxCpInviteResult.fromJson(this.mainService.post(url, jsonObject.toString()));
    }

    @Override
    public Map<String, String> userId2Openid(String userId, Integer agentId) throws WxErrorException {
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/user/convert_to_openid");
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("userid", userId);
        if (agentId != null) {
            jsonObject.addProperty("agentid", (Number)agentId);
        }
        String responseContent = this.mainService.post(url, jsonObject.toString());
        JsonElement tmpJsonElement = new JsonParser().parse(responseContent);
        HashMap result = Maps.newHashMap();
        if (tmpJsonElement.getAsJsonObject().get("openid") != null) {
            result.put("openid", tmpJsonElement.getAsJsonObject().get("openid").getAsString());
        }
        if (tmpJsonElement.getAsJsonObject().get("appid") != null) {
            result.put("appid", tmpJsonElement.getAsJsonObject().get("appid").getAsString());
        }
        return result;
    }

    @Override
    public String openid2UserId(String openid) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("openid", openid);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/user/convert_to_userid");
        String responseContent = this.mainService.post(url, jsonObject.toString());
        JsonElement tmpJsonElement = new JsonParser().parse(responseContent);
        return tmpJsonElement.getAsJsonObject().get("userid").getAsString();
    }

    @Override
    public String getUserId(String mobile) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("mobile", mobile);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/user/getuserid");
        String responseContent = this.mainService.post(url, jsonObject.toString());
        JsonElement tmpJsonElement = new JsonParser().parse(responseContent);
        return tmpJsonElement.getAsJsonObject().get("userid").getAsString();
    }

    @Override
    public WxCpUserExternalContactInfo getExternalContact(String userId) throws WxErrorException {
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/crm/get_external_contact?external_userid=" + userId);
        String responseContent = this.mainService.get(url, null);
        return WxCpUserExternalContactInfo.fromJson(responseContent);
    }

    public WxCpUserServiceImpl(WxCpService mainService) {
        this.mainService = mainService;
    }
}

