/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.api.impl;

import java.io.IOException;
import me.chanjar.weixin.common.WxType;
import me.chanjar.weixin.common.bean.WxAccessToken;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.http.HttpType;
import me.chanjar.weixin.common.util.http.okhttp.OkHttpProxyInfo;
import me.chanjar.weixin.cp.api.impl.BaseWxCpServiceImpl;
import me.chanjar.weixin.cp.config.WxCpConfigStorage;
import okhttp3.Authenticator;
import okhttp3.Credentials;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxCpServiceOkHttpImpl
extends BaseWxCpServiceImpl<OkHttpClient, OkHttpProxyInfo> {
    private static final Logger log = LoggerFactory.getLogger(WxCpServiceOkHttpImpl.class);
    private OkHttpClient httpClient;
    private OkHttpProxyInfo httpProxy;

    public OkHttpClient getRequestHttpClient() {
        return this.httpClient;
    }

    public OkHttpProxyInfo getRequestHttpProxy() {
        return this.httpProxy;
    }

    public HttpType getRequestType() {
        return HttpType.OK_HTTP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAccessToken(boolean forceRefresh) throws WxErrorException {
        if (!this.configStorage.isAccessTokenExpired() && !forceRefresh) {
            return this.configStorage.getAccessToken();
        }
        Object object = this.globalAccessTokenRefreshLock;
        synchronized (object) {
            OkHttpClient client = this.getRequestHttpClient();
            Request request = new Request.Builder().url(String.format(this.configStorage.getApiUrl("/cgi-bin/gettoken?&corpid=%s&corpsecret=%s"), this.configStorage.getCorpId(), this.configStorage.getCorpSecret())).get().build();
            String resultContent = null;
            try {
                Response response = client.newCall(request).execute();
                resultContent = response.body().string();
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            WxError error = WxError.fromJson((String)resultContent, (WxType)WxType.CP);
            if (error.getErrorCode() != 0) {
                throw new WxErrorException(error);
            }
            WxAccessToken accessToken = WxAccessToken.fromJson((String)resultContent);
            this.configStorage.updateAccessToken(accessToken.getAccessToken(), accessToken.getExpiresIn());
        }
        return this.configStorage.getAccessToken();
    }

    @Override
    public void initHttp() {
        log.debug("WxCpServiceOkHttpImpl initHttp");
        if (this.configStorage.getHttpProxyHost() != null && this.configStorage.getHttpProxyPort() > 0) {
            this.httpProxy = OkHttpProxyInfo.httpProxy((String)this.configStorage.getHttpProxyHost(), (int)this.configStorage.getHttpProxyPort(), (String)this.configStorage.getHttpProxyUsername(), (String)this.configStorage.getHttpProxyPassword());
        }
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
        if (this.httpProxy != null) {
            clientBuilder.proxy(this.getRequestHttpProxy().getProxy());
            clientBuilder.authenticator(new Authenticator(){

                public Request authenticate(Route route, Response response) throws IOException {
                    String credential = Credentials.basic((String)WxCpServiceOkHttpImpl.this.httpProxy.getProxyUsername(), (String)WxCpServiceOkHttpImpl.this.httpProxy.getProxyPassword());
                    return response.request().newBuilder().header("Authorization", credential).build();
                }
            });
        }
        this.httpClient = clientBuilder.build();
    }

    @Override
    public WxCpConfigStorage getWxCpConfigStorage() {
        return this.configStorage;
    }
}

