/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzWBh;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataTable;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DataColumnCollection
implements Iterable<DataColumn> {
    private final ArrayList<DataColumn> zzZoq = new ArrayList();
    private final Map<String, DataColumn> zzVQp = new HashMap<String, DataColumn>();
    private DataTable zzVV;

    DataColumnCollection(DataTable table) {
        this.zzVV = table;
    }

    public void add(DataColumn column) {
        if (zzWBh.zzJV(column.getColumnName())) {
            throw new IllegalArgumentException("Column name cannot be null or empty");
        }
        String string = DataColumnCollection.zzZjS(column.getColumnName());
        if (this.zzVQp.containsKey(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        column.zzX6U(this.zzVV);
        column.setOrdinal(this.zzZoq.size());
        this.zzZoq.add(column);
        this.zzVQp.put(string, column);
        this.zzVV.onDataColumnInserted(column);
    }

    public void add(String columnName) {
        this.add(columnName, String.class);
    }

    public DataColumn add(String columnName, Class type) {
        DataColumn dataColumn = new DataColumn(columnName, type, this.zzVV);
        this.add(dataColumn);
        return dataColumn;
    }

    public DataColumn add(String columnName, Class type, int columnMapping, boolean allowAutoIncrement, boolean allowDBNull) {
        DataColumn dataColumn = new DataColumn(columnName, type, this.zzVV);
        dataColumn.setColumnMapping(columnMapping);
        dataColumn.setAutoIncrement(allowAutoIncrement);
        dataColumn.setAllowDBNull(allowDBNull);
        this.add(dataColumn);
        return dataColumn;
    }

    public int indexOf(String columnName) {
        if (zzWBh.zzJV(columnName)) {
            return -1;
        }
        String string = DataColumnCollection.zzZjS(columnName);
        DataColumn dataColumn = this.zzVQp.get(string);
        if (dataColumn != null) {
            int n = this.zzZoq.size();
            for (int i = 0; i < n; ++i) {
                if (this.zzZoq.get(i) != dataColumn) continue;
                return i;
            }
        }
        return -1;
    }

    public int indexOf(DataColumn column) {
        if (column == null) {
            return -1;
        }
        return this.indexOf(column.getColumnName());
    }

    public DataColumn get(int index) {
        return this.zzZoq.get(index);
    }

    public DataColumn get(String columnName) {
        int n = this.indexOf(columnName);
        if (n >= 0) {
            return this.get(n);
        }
        return null;
    }

    public boolean contains(String name) {
        return this.indexOf(name) >= 0;
    }

    public void remove(String name) {
        int n = this.indexOf(name);
        if (n >= 0) {
            DataColumn dataColumn = this.zzZoq.remove(n);
            this.zzVQp.remove(DataColumnCollection.zzZjS(dataColumn.getColumnName()));
            for (DataRow dataRow : this.zzVV.getRows()) {
                dataRow.remove(n);
            }
            this.zzVV.onDataColumnDeleted(dataColumn);
        }
    }

    public void remove(DataColumn column) {
        this.remove(column.getColumnName());
    }

    public int getCount() {
        return this.zzZoq.size();
    }

    @Override
    public Iterator<DataColumn> iterator() {
        return this.zzZoq.iterator();
    }

    public void clear() {
        this.zzVQp.clear();
        this.zzZoq.clear();
    }

    final DataColumn[] zzYHN() {
        ArrayList<DataColumn> arrayList = new ArrayList<DataColumn>(this.zzZoq);
        return arrayList.toArray(new DataColumn[arrayList.size()]);
    }

    final void zzXDk(String string, DataColumn dataColumn) {
        if (this.contains(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        int n = this.zzZoq.size();
        for (int i = 0; i < n; ++i) {
            if (this.zzZoq.get(i) != dataColumn) continue;
            String string2 = DataColumnCollection.zzZjS(string);
            String string3 = DataColumnCollection.zzZjS(dataColumn.getColumnName());
            this.zzVQp.remove(string3);
            this.zzVQp.put(string2, dataColumn);
            return;
        }
    }

    private static String zzZjS(String string) {
        return Normalizer.normalize(string.toLowerCase(), Normalizer.Form.NFD);
    }
}

