/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.HeaderFooter;
import com.aspose.words.HeaderFooterCollection;
import com.aspose.words.Node;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SectionStart;
import com.aspose.words.Shape;
import com.aspose.words.Story;
import com.aspose.words.internal.zzWBh;
import com.aspose.words.internal.zzWJv;
import com.aspose.words.zz8x;
import com.aspose.words.zzXUC;
import com.aspose.words.zzXqN;
import com.aspose.words.zzYAn;
import java.util.ArrayList;

public final class Section
extends CompositeNode<Node>
implements zz8x {
    private zzXqN zzXIe;
    private PageSetup zzIX;
    private HeaderFooterCollection zzZ9f;

    public Section(DocumentBase doc) {
        this(doc, new zzXqN());
    }

    Section(DocumentBase doc, zzXqN sectPr) {
        super(doc);
        this.zzXIe = sectPr;
    }

    @Override
    public final int getNodeType() {
        return 2;
    }

    public final Body getBody() {
        return (Body)this.getChild(3, 0, false);
    }

    public final HeaderFooterCollection getHeadersFooters() {
        if (this.zzZ9f == null) {
            this.zzZ9f = new HeaderFooterCollection(this);
        }
        return this.zzZ9f;
    }

    public final PageSetup getPageSetup() {
        if (this.zzIX == null) {
            Section section = this;
            this.zzIX = new PageSetup(section, section.getDocument().zzL4(), this.getDocument().getStyles(), new zzXDk(this));
        }
        return this.zzIX;
    }

    public final boolean getProtectedForForms() {
        return !this.getPageSetup().zzXZD();
    }

    public final void setProtectedForForms(boolean value) {
        this.getPageSetup().zzXyK(!value);
    }

    final zzXqN zzYbs() {
        return this.zzXIe;
    }

    final void zzWew(zzXqN zzXqN2) {
        this.zzXIe = zzXqN2;
    }

    public final Section deepClone() {
        return (Section)this.deepClone(true);
    }

    @Override
    final Node zzXDk(boolean bl, zzYAn zzYAn2) {
        zzXqN zzXqN2;
        Section section = (Section)super.zzXDk(bl, zzYAn2);
        zzXqN zzXqN3 = this.zzXIe;
        section.zzXIe = zzXqN2 = (zzXqN)zzXqN3.zzXQq();
        section.zzIX = null;
        section.zzZ9f = null;
        return section;
    }

    @Override
    public final boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    public final int acceptStart(DocumentVisitor visitor) throws Exception {
        return visitor.visitSectionStart(this);
    }

    @Override
    public final int acceptEnd(DocumentVisitor visitor) throws Exception {
        return visitor.visitSectionEnd(this);
    }

    public final void prependContent(Section sourceSection) {
        this.zzX6U(sourceSection, false);
    }

    public final void appendContent(Section sourceSection) {
        this.zzX6U(sourceSection, true);
    }

    public final void clearContent() {
        this.clearHeadersFooters();
        this.getBody().removeAllChildren();
        this.getBody().ensureMinimum();
    }

    public final void clearHeadersFooters() {
        this.clearHeadersFooters(false);
    }

    public final void clearHeadersFooters(boolean preserveWatermarks) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            HeaderFooter headerFooter = (HeaderFooter)node;
            ArrayList arrayList = preserveWatermarks ? headerFooter.getChildNodes(18, true).zzZcF() : zzXUC.zzXsp().zzZcF();
            headerFooter.removeAllChildren();
            for (Shape shape : arrayList) {
                if (!shape.zzZ1M() && !shape.zzYxz()) continue;
                headerFooter.appendChild(new Paragraph(this.getDocument()));
                headerFooter.getFirstParagraph().appendChild(shape);
            }
        }
    }

    public final void deleteHeaderFooterShapes() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).deleteShapes();
        }
    }

    public final void ensureMinimum() {
        Body body = this.getBody();
        if (body == null) {
            body = this.appendChild(new Body(this.getDocument()));
        }
        body.ensureMinimum();
    }

    final void zzWkE(int n) {
        switch (n) {
            case 1033: 
            case 2058: 
            case 4105: 
            case 5130: 
            case 8202: 
            case 9226: 
            case 13321: 
            case 13322: {
                this.getPageSetup().setPaperSize(9);
                return;
            }
        }
        this.getPageSetup().setPaperSize(1);
    }

    final Story zzZDz(int n) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (((Story)node).getStoryType() != n) continue;
            return (Story)node;
        }
        return null;
    }

    @Override
    final boolean zzXcI(Node node) {
        switch (node.getNodeType()) {
            case 3: 
            case 4: {
                int n = ((Story)node).getStoryType();
                return this.zzZDz(n) == null;
            }
        }
        return false;
    }

    final void zzWew(Shape shape, boolean bl) throws Exception {
        this.zzXDk(shape, 4, bl);
        this.zzXDk(shape, 0, bl);
        this.zzXDk(shape, 1, bl);
    }

    private void zzXDk(Shape shape, int n, boolean bl) throws Exception {
        HeaderFooter headerFooter = this.getHeadersFooters().getByHeaderFooterType(n);
        if (headerFooter == null) {
            if (!bl) {
                return;
            }
            headerFooter = new HeaderFooter(this.getDocument(), n);
            this.getHeadersFooters().add(headerFooter);
        }
        if (headerFooter.getParagraphs().getCount() == 0) {
            headerFooter.appendChild(new Paragraph(this.getDocument()));
        }
        Shape shape2 = (Shape)shape.deepClone(true);
        shape2.setId(shape2.getDocument().zzWIo());
        shape2.setName(zzWBh.zzaQ("{0}{1}", shape2.hasImage() ? "WordPictureWatermark" : "PowerPlusWaterMarkObject", shape2.getId()));
        headerFooter.getFirstParagraph().appendChild(shape2);
    }

    final boolean zzZpY() {
        boolean bl = false;
        for (HeaderFooter headerFooter : this.getHeadersFooters()) {
            if (!headerFooter.isHeader()) continue;
            for (Shape shape : headerFooter.zzZas()) {
                if (!shape.zzXUH()) continue;
                shape.remove();
                bl = true;
            }
        }
        return bl;
    }

    private void zzX6U(Section section, boolean bl) {
        Paragraph paragraph;
        if (section == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: sourceSection");
        }
        Body body = section.getBody();
        if (body == null) {
            return;
        }
        Body body2 = this.getBody();
        if (body2 == null) {
            body2 = this.appendChild(new Body(this.getDocument()));
        }
        body = (Body)this.getDocument().importNode(body, true);
        CompositeNode compositeNode = paragraph = bl ? body2.getLastParagraph() : null;
        while (compositeNode != null && paragraph.getParentNode() != body2) {
            compositeNode = paragraph.getParentNode();
        }
        body2.zzaQ(body.getFirstChild(), null, paragraph);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object getDirectSectionAttr(int key) {
        return this.zzXIe.zzYfo(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object getDirectSectionAttr(int key, int revisionsView) {
        return this.zzXIe.zzST(key, revisionsView);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchInheritedSectionAttr(int key) {
        if (key == 2600) {
            return this.getDocument().zzL4().zzaj.zzYho(key);
        }
        return zzXqN.zzYBr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchSectionAttr(int key) {
        Object object = this.getDirectSectionAttr(key);
        if (object != null) {
            return object;
        }
        return this.fetchInheritedSectionAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchSectionAttr(int key, int revisionsView) {
        Object object = this.getDirectSectionAttr(key, revisionsView);
        if (object != null) {
            return object;
        }
        return this.fetchInheritedSectionAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setSectionAttr(int key, Object value) {
        if (key == 2260 || key == 2270) {
            this.zzXIe.remove(2090);
        }
        if (key == 2600) {
            this.getDocument().zzL4().zzaj.zzXFB(key, value);
            return;
        }
        this.zzXIe.zzXFB(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setSectionAttr(int key, Object value, int revisionsView) {
        if (key == 2260 || key == 2270) {
            this.zzXIe.zzZ7l(2090, revisionsView);
        }
        if (key == 2600) {
            this.getDocument().zzL4().zzaj.zzaQ(key, value, revisionsView);
            return;
        }
        this.zzXIe.zzaQ(key, value, revisionsView);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void clearSectionAttrs() {
        this.zzXIe.clear();
    }

    final boolean zzZB2() {
        return this.getParentNode().getFirstChild() == this;
    }

    final boolean zzYxd() {
        return this.getParentNode().getLastChild() == this;
    }

    @Override
    public final String toString() {
        Object[] objectArray = new Object[2];
        objectArray[0] = super.toString();
        Section section = this;
        objectArray[1] = SectionStart.toString(section.zzXIe.getSectionStart());
        return zzWBh.zzaQ("{0} {1}", objectArray);
    }

    static final class zzXDk
    implements zz8x {
        private Section zzWVm;

        zzXDk(Section section) {
            this.zzWVm = section;
        }

        @Override
        public final Object getDirectSectionAttr(int key) {
            return this.zzX6L().getDirectSectionAttr(key);
        }

        @Override
        public final Object getDirectSectionAttr(int key, int revisionsView) {
            return this.zzX6L().getDirectSectionAttr(key, revisionsView);
        }

        @Override
        public final Object fetchInheritedSectionAttr(int key) {
            return this.zzX6L().fetchInheritedSectionAttr(key);
        }

        @Override
        public final Object fetchSectionAttr(int key) {
            return this.zzX6L().fetchSectionAttr(key);
        }

        @Override
        public final Object fetchSectionAttr(int key, int revisionsView) {
            return this.zzX6L().fetchSectionAttr(key, revisionsView);
        }

        @Override
        public final void setSectionAttr(int key, Object value) {
        }

        @Override
        public final void setSectionAttr(int key, Object value, int revisionsView) {
        }

        @Override
        public final void clearSectionAttrs() {
        }

        private zz8x zzX6L() {
            Document document = zzWJv.zzXDk((Object)this.zzWVm.getDocument(), Document.class);
            if (document != null && document.getFirstSection() != null) {
                return document.getFirstSection();
            }
            return this.zzWVm;
        }
    }
}

