/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocSaveOptions;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.HtmlFixedSaveOptions;
import com.aspose.words.HtmlSaveOptions;
import com.aspose.words.IDocumentSavingCallback;
import com.aspose.words.ImageSaveOptions;
import com.aspose.words.MarkdownSaveOptions;
import com.aspose.words.OdtSaveOptions;
import com.aspose.words.OoxmlSaveOptions;
import com.aspose.words.PclSaveOptions;
import com.aspose.words.PdfSaveOptions;
import com.aspose.words.PsSaveOptions;
import com.aspose.words.RtfSaveOptions;
import com.aspose.words.SvgSaveOptions;
import com.aspose.words.TxtSaveOptions;
import com.aspose.words.WordML2003SaveOptions;
import com.aspose.words.XamlFixedSaveOptions;
import com.aspose.words.XamlFlowSaveOptions;
import com.aspose.words.XlsxSaveOptions;
import com.aspose.words.XpsSaveOptions;
import com.aspose.words.internal.zz3u;
import com.aspose.words.internal.zzW9V;
import com.aspose.words.internal.zzWZ9;
import java.util.TimeZone;

public abstract class SaveOptions {
    private IDocumentSavingCallback zzYfM;
    private boolean zzXbt;
    boolean zzZZn = true;
    private boolean zzHK = true;
    private boolean zzZhA = false;
    private boolean zzY7W;
    private boolean zzWxi = true;
    private boolean zzYSE;
    private String zzZrh;
    private boolean zzZls;
    private boolean zzYcM = false;
    private int zzRy = 1;
    private int zzYTt = 1;
    private int zzVy = 0;
    private String zzYs2 = "";
    private boolean zzXsu = true;
    private boolean zzYr9 = true;
    private boolean zzWVD;
    private boolean zzYii;
    private int zzeN = 0;
    private boolean zzVOW = true;
    private boolean zzJJ = false;
    private boolean zzW0Z = false;
    private TimeZone zzYCi = zzW9V.getTimeZone();

    protected SaveOptions() {
    }

    final boolean zzYoE() {
        return this.zzY7W;
    }

    public abstract int getSaveFormat();

    public abstract void setSaveFormat(int var1);

    boolean zzO2() {
        return false;
    }

    boolean zzWaD() {
        return true;
    }

    public boolean getExportGeneratorName() {
        return this.zzWxi;
    }

    public void setExportGeneratorName(boolean value) {
        this.zzWxi = value;
    }

    public String getTempFolder() {
        return this.zzZrh;
    }

    public void setTempFolder(String value) {
        this.zzZrh = value;
    }

    public boolean getPrettyFormat() {
        return this.zzYSE;
    }

    public void setPrettyFormat(boolean value) {
        this.zzYSE = value;
    }

    public boolean getUseAntiAliasing() {
        return this.zzZls;
    }

    public void setUseAntiAliasing(boolean value) {
        this.zzZls = value;
    }

    public boolean getUseHighQualityRendering() {
        return this.zzYcM;
    }

    public void setUseHighQualityRendering(boolean value) {
        this.zzYcM = value;
    }

    public int getDmlRenderingMode() {
        return this.zzRy;
    }

    public void setDmlRenderingMode(int value) {
        this.zzRy = value;
    }

    public int getDmlEffectsRenderingMode() {
        return this.zzVy;
    }

    public void setDmlEffectsRenderingMode(int value) {
        this.zzVy = value;
    }

    public int getImlRenderingMode() {
        return this.zzYTt;
    }

    public void setImlRenderingMode(int value) {
        this.zzYTt = value;
    }

    public String getDefaultTemplate() {
        return this.zzYs2;
    }

    public void setDefaultTemplate(String value) {
        this.zzYs2 = value;
    }

    public boolean getUpdateFields() {
        return this.zzXsu;
    }

    public void setUpdateFields(boolean value) {
        this.zzXsu = value;
    }

    public boolean getUpdateLastSavedTimeProperty() {
        return this.zzWVD;
    }

    public void setUpdateLastSavedTimeProperty(boolean value) {
        this.zzWVD = value;
    }

    public boolean getUpdateLastPrintedProperty() {
        return this.zzYii;
    }

    public void setUpdateLastPrintedProperty(boolean value) {
        this.zzYii = value;
    }

    public boolean getUpdateCreatedTimeProperty() {
        return this.zzJJ;
    }

    public void setUpdateCreatedTimeProperty(boolean value) {
        this.zzJJ = value;
    }

    public boolean getMemoryOptimization() {
        return this.zzZhA;
    }

    public void setMemoryOptimization(boolean value) {
        this.zzZhA = value;
    }

    public boolean getUpdateAmbiguousTextFont() {
        return this.zzW0Z;
    }

    public void setUpdateAmbiguousTextFont(boolean value) {
        this.zzW0Z = value;
    }

    final boolean zzX5r() {
        return this.zzYr9;
    }

    final boolean zzZP8() {
        return this.zzVOW;
    }

    public static SaveOptions createSaveOptions(int saveFormat) {
        switch (saveFormat) {
            case 10: 
            case 11: {
                return new DocSaveOptions(saveFormat);
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return new OoxmlSaveOptions(saveFormat);
            }
            case 30: {
                return new RtfSaveOptions();
            }
            case 31: {
                return new WordML2003SaveOptions();
            }
            case 40: {
                return new PdfSaveOptions();
            }
            case 47: {
                return new PsSaveOptions();
            }
            case 48: {
                return new PclSaveOptions();
            }
            case 41: {
                return new XpsSaveOptions(41);
            }
            case 46: {
                return new XpsSaveOptions(46);
            }
            case 42: {
                return new XamlFixedSaveOptions();
            }
            case 44: {
                return new SvgSaveOptions();
            }
            case 45: {
                return new HtmlFixedSaveOptions();
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                return new HtmlSaveOptions(saveFormat);
            }
            case 60: 
            case 61: {
                return new OdtSaveOptions(saveFormat);
            }
            case 70: {
                return new TxtSaveOptions();
            }
            case 71: {
                return new XamlFlowSaveOptions();
            }
            case 72: {
                return new XamlFlowSaveOptions(saveFormat);
            }
            case 73: {
                return new MarkdownSaveOptions();
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: {
                return new ImageSaveOptions(saveFormat);
            }
            case 80: {
                return new XlsxSaveOptions();
            }
        }
        throw new IllegalArgumentException("Invalid save format requested.");
    }

    public static SaveOptions createSaveOptions(String fileName) throws Exception {
        return SaveOptions.createSaveOptions(FileFormatUtil.zzY3F(zzWZ9.zzZlN(zz3u.zzZ3C(fileName))));
    }

    public int getDml3DEffectsRenderingMode() {
        return this.zzeN;
    }

    public void setDml3DEffectsRenderingMode(int value) {
        this.zzeN = value;
    }

    public IDocumentSavingCallback getProgressCallback() {
        return this.zzYfM;
    }

    public void setProgressCallback(IDocumentSavingCallback value) {
        this.zzYfM = value;
    }

    public boolean getAllowEmbeddingPostScriptFonts() {
        return this.zzXbt;
    }

    public void setAllowEmbeddingPostScriptFonts(boolean value) {
        this.zzXbt = value;
    }

    public TimeZone getCustomTimeZoneInfo() {
        return this.zzYCi;
    }

    public void setCustomTimeZoneInfo(TimeZone value) {
        this.zzYCi = value;
    }

    final boolean zzZlS() {
        return this.zzHK;
    }

    final void zzWEn(boolean bl) {
        this.zzHK = false;
    }
}

