/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Document;
import com.aspose.words.DocumentBuilder;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.FindReplaceOptions;
import com.aspose.words.ImageSaveOptions;
import com.aspose.words.ImportFormatOptions;
import com.aspose.words.LoadOptions;
import com.aspose.words.Node;
import com.aspose.words.Processor;
import com.aspose.words.ReplacerContext;
import com.aspose.words.Run;
import com.aspose.words.SaveOptions;
import com.aspose.words.internal.zz3u;
import com.aspose.words.internal.zzY61;
import com.aspose.words.internal.zzYo1;
import com.aspose.words.internal.zzYpd;
import com.aspose.words.internal.zzZOd;
import com.aspose.words.zzXUC;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.regex.Pattern;

public class Replacer
extends Processor {
    private ReplacerContext zzZd8;

    private Replacer(ReplacerContext context) {
        super(context);
        this.zzZd8 = context;
    }

    public static Replacer create(ReplacerContext context) {
        return new Replacer(context);
    }

    @Override
    protected void executeCore() throws Exception {
        this.mResultDocument = this.zzZRZ().zzZ8u();
        this.zzZd8.zz1s(Replacer.zzXDk(this.mResultDocument, this.zzZd8.zzZPv(), this.zzZd8.getReplacement(), this.zzZd8.getFindReplaceOptions()));
        super.executeCore();
    }

    @Override
    protected void checkArgumentsSet() {
        if (this.zzZd8.zzZPv() == null) {
            throw new IllegalArgumentException("Search pattern is not specified. Specify search pattern and replacement using ReplacerContext.SetReplacement method.");
        }
        super.checkArgumentsSet();
    }

    public static int replace(String inputFileName, String outputFileName, String pattern, String replacement) throws Exception {
        int n = FileFormatUtil.extensionToSaveFormat(zz3u.zzZ3C(outputFileName));
        return Replacer.replace(inputFileName, outputFileName, n, pattern, replacement);
    }

    public static int replace(String inputFileName, String outputFileName, int saveFormat, String pattern, String replacement) throws Exception {
        return Replacer.replace(inputFileName, outputFileName, saveFormat, pattern, replacement, null);
    }

    public static int replace(String inputFileName, String outputFileName, int saveFormat, String pattern, String replacement, FindReplaceOptions options) throws Exception {
        return Replacer.replace(inputFileName, outputFileName, zzXUC.zzX1p(saveFormat, outputFileName), pattern, replacement, options);
    }

    public static int replace(String inputFileName, String outputFileName, SaveOptions saveOptions, String pattern, String replacement) throws Exception {
        return Replacer.replace(inputFileName, outputFileName, saveOptions, pattern, replacement, null);
    }

    public static int replace(String inputFileName, String outputFileName, SaveOptions saveOptions, String pattern, String replacement, FindReplaceOptions options) throws Exception {
        ReplacerContext replacerContext = new ReplacerContext();
        replacerContext.setReplacement(pattern, replacement);
        if (options != null) {
            replacerContext.zzXDk(options);
        }
        Replacer.create(replacerContext).from(inputFileName).to(outputFileName, saveOptions).execute();
        return replacerContext.zzWAx();
    }

    private static int zzXDk(zzYo1 zzYo12, zzYo1 zzYo13, int n, String string, String string2, FindReplaceOptions findReplaceOptions) throws Exception {
        return Replacer.zzXDk(zzYo12, zzYo13, zzXUC.zzX1p(n, null), string, string2, findReplaceOptions);
    }

    public static int replace(InputStream inputStream, OutputStream outputStream, int saveFormat, String pattern, String replacement) throws Exception {
        return Replacer.zzXDk(zzYo1.zzaQ(inputStream), (zzYo1)zzYo1.zzWew(outputStream), saveFormat, pattern, replacement, null);
    }

    public static int replace(InputStream inputStream, OutputStream outputStream, int saveFormat, String pattern, String replacement, FindReplaceOptions options) throws Exception {
        return Replacer.zzXDk(zzYo1.zzaQ(inputStream), (zzYo1)zzYo1.zzWew(outputStream), saveFormat, pattern, replacement, options);
    }

    private static int zzXDk(zzYo1 zzYo12, zzYo1 zzYo13, SaveOptions saveOptions, String string, String string2, FindReplaceOptions findReplaceOptions) throws Exception {
        ReplacerContext replacerContext = new ReplacerContext();
        replacerContext.setReplacement(string, string2);
        if (findReplaceOptions != null) {
            replacerContext.zzXDk(findReplaceOptions);
        }
        Replacer.create(replacerContext).zzZJF(zzYo12).zzaQ(zzYo13, saveOptions).execute();
        return replacerContext.zzWAx();
    }

    public static int replace(InputStream inputStream, OutputStream outputStream, SaveOptions saveOptions, String pattern, String replacement) throws Exception {
        return Replacer.zzXDk(zzYo1.zzaQ(inputStream), (zzYo1)zzYo1.zzWew(outputStream), saveOptions, pattern, replacement, null);
    }

    public static int replace(InputStream inputStream, OutputStream outputStream, SaveOptions saveOptions, String pattern, String replacement, FindReplaceOptions options) throws Exception {
        return Replacer.zzXDk(zzYo1.zzaQ(inputStream), (zzYo1)zzYo1.zzWew(outputStream), saveOptions, pattern, replacement, options);
    }

    private static int zzXDk(String string, String string2, zzZOd zzZOd2, String string3) throws Exception {
        int n = FileFormatUtil.extensionToSaveFormat(zz3u.zzZ3C(string2));
        return Replacer.zzXDk(string, string2, n, zzZOd2, string3);
    }

    public static int replace(String inputFileName, String outputFileName, Pattern pattern, String replacement) throws Exception {
        return Replacer.zzXDk(inputFileName, outputFileName, zzZOd.zzXDk(pattern), replacement);
    }

    private static int zzXDk(String string, String string2, int n, zzZOd zzZOd2, String string3) throws Exception {
        return Replacer.zzXDk(string, string2, n, zzZOd2, string3, null);
    }

    private static int zzXDk(String string, String string2, int n, zzZOd zzZOd2, String string3, FindReplaceOptions findReplaceOptions) throws Exception {
        return Replacer.zzXDk(string, string2, zzXUC.zzX1p(n, string2), zzZOd2, string3, findReplaceOptions);
    }

    public static int replace(String inputFileName, String outputFileName, int saveFormat, Pattern pattern, String replacement) throws Exception {
        return Replacer.zzXDk(inputFileName, outputFileName, saveFormat, zzZOd.zzXDk(pattern), replacement, null);
    }

    public static int replace(String inputFileName, String outputFileName, int saveFormat, Pattern pattern, String replacement, FindReplaceOptions options) throws Exception {
        return Replacer.zzXDk(inputFileName, outputFileName, saveFormat, zzZOd.zzXDk(pattern), replacement, options);
    }

    private static int zzXDk(String string, String string2, SaveOptions saveOptions, zzZOd zzZOd2, String string3, FindReplaceOptions findReplaceOptions) throws Exception {
        ReplacerContext replacerContext = new ReplacerContext();
        replacerContext.zzaQ(zzZOd2, string3);
        if (findReplaceOptions != null) {
            replacerContext.zzXDk(findReplaceOptions);
        }
        Replacer.create(replacerContext).from(string).to(string2, saveOptions).execute();
        return replacerContext.zzWAx();
    }

    public static int replace(String inputFileName, String outputFileName, SaveOptions saveOptions, Pattern pattern, String replacement) throws Exception {
        return Replacer.zzXDk(inputFileName, outputFileName, saveOptions, zzZOd.zzXDk(pattern), replacement, null);
    }

    public static int replace(String inputFileName, String outputFileName, SaveOptions saveOptions, Pattern pattern, String replacement, FindReplaceOptions options) throws Exception {
        return Replacer.zzXDk(inputFileName, outputFileName, saveOptions, zzZOd.zzXDk(pattern), replacement, options);
    }

    private static int zzXDk(zzYo1 zzYo12, zzYo1 zzYo13, int n, zzZOd zzZOd2, String string, FindReplaceOptions findReplaceOptions) throws Exception {
        return Replacer.zzXDk(zzYo12, zzYo13, zzXUC.zzX1p(n, null), zzZOd2, string, findReplaceOptions);
    }

    public static int replace(InputStream inputStream, OutputStream outputStream, int saveFormat, Pattern pattern, String replacement) throws Exception {
        return Replacer.zzXDk(zzYo1.zzaQ(inputStream), (zzYo1)zzYo1.zzWew(outputStream), saveFormat, zzZOd.zzXDk(pattern), replacement, null);
    }

    public static int replace(InputStream inputStream, OutputStream outputStream, int saveFormat, Pattern pattern, String replacement, FindReplaceOptions options) throws Exception {
        return Replacer.zzXDk(zzYo1.zzaQ(inputStream), (zzYo1)zzYo1.zzWew(outputStream), saveFormat, zzZOd.zzXDk(pattern), replacement, options);
    }

    private static int zzXDk(zzYo1 zzYo12, zzYo1 zzYo13, SaveOptions saveOptions, zzZOd zzZOd2, String string, FindReplaceOptions findReplaceOptions) throws Exception {
        ReplacerContext replacerContext = new ReplacerContext();
        replacerContext.zzaQ(zzZOd2, string);
        if (findReplaceOptions != null) {
            replacerContext.zzXDk(findReplaceOptions);
        }
        Replacer.create(replacerContext).zzZJF(zzYo12).zzaQ(zzYo13, saveOptions).execute();
        return replacerContext.zzWAx();
    }

    public static int replace(InputStream inputStream, OutputStream outputStream, SaveOptions saveOptions, Pattern pattern, String replacement) throws Exception {
        return Replacer.zzXDk(zzYo1.zzaQ(inputStream), (zzYo1)zzYo1.zzWew(outputStream), saveOptions, zzZOd.zzXDk(pattern), replacement, null);
    }

    public static int replace(InputStream inputStream, OutputStream outputStream, SaveOptions saveOptions, Pattern pattern, String replacement, FindReplaceOptions options) throws Exception {
        return Replacer.zzXDk(zzYo1.zzaQ(inputStream), (zzYo1)zzYo1.zzWew(outputStream), saveOptions, zzZOd.zzXDk(pattern), replacement, options);
    }

    private static zzYo1[] zzXDk(String string, ImageSaveOptions imageSaveOptions, String string2, String string3, FindReplaceOptions findReplaceOptions) throws Exception {
        return Replacer.zzXDk(string, imageSaveOptions, new zzZOd(zzZOd.zzWON(string2)), string3, findReplaceOptions);
    }

    public static OutputStream[] replaceToImages(String inputFileName, ImageSaveOptions saveOptions, String pattern, String replacement) throws Exception {
        return zzYo1.zzaQ(Replacer.zzXDk(inputFileName, saveOptions, pattern, replacement, null));
    }

    public static OutputStream[] replaceToImages(String inputFileName, ImageSaveOptions saveOptions, String pattern, String replacement, FindReplaceOptions options) throws Exception {
        return zzYo1.zzaQ(Replacer.zzXDk(inputFileName, saveOptions, pattern, replacement, options));
    }

    private static zzYo1[] zzXDk(zzYo1 zzYo12, ImageSaveOptions imageSaveOptions, String string, String string2, FindReplaceOptions findReplaceOptions) throws Exception {
        return Replacer.zzXDk(zzYo12, imageSaveOptions, new zzZOd(zzZOd.zzWON(string)), string2, findReplaceOptions);
    }

    public static OutputStream[] replaceToImages(InputStream inputStream, ImageSaveOptions saveOptions, String pattern, String replacement) throws Exception {
        return zzYo1.zzaQ(Replacer.zzXDk(zzYo1.zzaQ(inputStream), saveOptions, pattern, replacement, null));
    }

    public static OutputStream[] replaceToImages(InputStream inputStream, ImageSaveOptions saveOptions, String pattern, String replacement, FindReplaceOptions options) throws Exception {
        return zzYo1.zzaQ(Replacer.zzXDk(zzYo1.zzaQ(inputStream), saveOptions, pattern, replacement, options));
    }

    private static zzYo1[] zzXDk(String string, ImageSaveOptions imageSaveOptions, zzZOd zzZOd2, String string2, FindReplaceOptions findReplaceOptions) throws Exception {
        ReplacerContext replacerContext = new ReplacerContext();
        replacerContext.zzaQ(zzZOd2, string2);
        if (findReplaceOptions != null) {
            replacerContext.zzXDk(findReplaceOptions);
        }
        ArrayList<zzYo1> arrayList = new ArrayList<zzYo1>();
        Replacer.create(replacerContext).from(string).to(arrayList, (SaveOptions)imageSaveOptions).execute();
        zzYo1[] zzYo1Array = new zzYo1[]{};
        ArrayList<zzYo1> arrayList2 = arrayList;
        return arrayList2.toArray(zzYo1Array);
    }

    public static OutputStream[] replaceToImages(String inputFileName, ImageSaveOptions saveOptions, Pattern pattern, String replacement) throws Exception {
        return zzYo1.zzaQ(Replacer.zzXDk(inputFileName, saveOptions, zzZOd.zzXDk(pattern), replacement, null));
    }

    public static OutputStream[] replaceToImages(String inputFileName, ImageSaveOptions saveOptions, Pattern pattern, String replacement, FindReplaceOptions options) throws Exception {
        return zzYo1.zzaQ(Replacer.zzXDk(inputFileName, saveOptions, zzZOd.zzXDk(pattern), replacement, options));
    }

    private static zzYo1[] zzXDk(zzYo1 zzYo12, ImageSaveOptions imageSaveOptions, zzZOd zzZOd2, String string, FindReplaceOptions findReplaceOptions) throws Exception {
        ReplacerContext replacerContext = new ReplacerContext();
        replacerContext.zzaQ(zzZOd2, string);
        if (findReplaceOptions != null) {
            replacerContext.zzXDk(findReplaceOptions);
        }
        ArrayList<zzYo1> arrayList = new ArrayList<zzYo1>();
        Replacer.create(replacerContext).zzZJF(zzYo12).to(arrayList, (SaveOptions)imageSaveOptions).execute();
        zzYo1[] zzYo1Array = new zzYo1[]{};
        ArrayList<zzYo1> arrayList2 = arrayList;
        return arrayList2.toArray(zzYo1Array);
    }

    public static OutputStream[] replaceToImages(InputStream inputStream, ImageSaveOptions saveOptions, Pattern pattern, String replacement) throws Exception {
        return zzYo1.zzaQ(Replacer.zzXDk(zzYo1.zzaQ(inputStream), saveOptions, zzZOd.zzXDk(pattern), replacement, null));
    }

    public static OutputStream[] replaceToImages(InputStream inputStream, ImageSaveOptions saveOptions, Pattern pattern, String replacement, FindReplaceOptions options) throws Exception {
        return zzYo1.zzaQ(Replacer.zzXDk(zzYo1.zzaQ(inputStream), saveOptions, zzZOd.zzXDk(pattern), replacement, options));
    }

    private static int zzXDk(Document document, zzZOd zzZOd2, String string, FindReplaceOptions findReplaceOptions) throws Exception {
        if (findReplaceOptions.getReplacementFormat() == 0) {
            return document.getRange().zzXDk(zzZOd2, string, findReplaceOptions);
        }
        int n = document.getRange().zzXDk(zzZOd2, "[[WordizeTempPlaceholder]]", findReplaceOptions);
        Replacer.zzXDk(document, string, findReplaceOptions.getReplacementFormat());
        return n;
    }

    private static void zzXDk(Document document, String string, int n) throws Exception {
        DocumentBuilder documentBuilder = new DocumentBuilder(document);
        for (Node node : document.getChildNodes(21, true)) {
            Run run = (Run)node;
            if (!"[[WordizeTempPlaceholder]]".equals(run.getText())) continue;
            documentBuilder.moveTo(run);
            switch (n) {
                case 2: {
                    documentBuilder.insertHtml(string, 2);
                    break;
                }
                case 1: {
                    try (zzY61 zzY612 = new zzY61(zzYpd.zzcd().zzya(string));){
                        LoadOptions loadOptions = new LoadOptions();
                        loadOptions.setLoadFormat(63);
                        Document document2 = new Document(zzY612, loadOptions);
                        documentBuilder.insertDocumentInline(document2, 0, new ImportFormatOptions());
                        break;
                    }
                }
                default: {
                    documentBuilder.write(string);
                }
            }
            run.remove();
        }
    }
}

