/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.internal.zzVQF;
import com.aspose.words.internal.zzYzF;
import java.awt.Color;

public final class MultiPageLayout {
    private float zzYiq;
    private zzVQF zzZ5G;
    private zzVQF zzWEt;
    private float zzZmc;
    private float zzZEZ;
    private int zzYwD;
    private int zzWNu;

    private MultiPageLayout(int mode, int columns, float horizontalGap, float verticalGap) {
        if (horizontalGap < 0.0f) {
            throw new IllegalArgumentException("Horizontal gap must be non-negative.\r\nParameter name: horizontalGap");
        }
        if (verticalGap < 0.0f) {
            throw new IllegalArgumentException("Vertical gap must be non-negative.\r\nParameter name: verticalGap");
        }
        this.zzWNu = mode;
        this.zzYwD = columns;
        this.zzZEZ = horizontalGap;
        this.zzZmc = verticalGap;
        this.setBorderWidth(0.0f);
        this.setBorderColor(zzYzF.zzXgy);
        this.setBackColor(zzYzF.zzXgy);
    }

    public static MultiPageLayout vertical(float verticalGap) {
        return new MultiPageLayout(1, 1, 0.0f, verticalGap);
    }

    public static MultiPageLayout horizontal(float horizontalGap) {
        return new MultiPageLayout(2, Integer.MAX_VALUE, horizontalGap, 0.0f);
    }

    public static MultiPageLayout grid(int columns, float horizontalGap, float verticalGap) {
        if (columns <= 0) {
            throw new IllegalArgumentException("Columns must be greater than zero.\r\nParameter name: columns");
        }
        return new MultiPageLayout(3, columns, horizontalGap, verticalGap);
    }

    public static MultiPageLayout tiffFrames() {
        return new MultiPageLayout(4, 0, 0.0f, 0.0f);
    }

    public static MultiPageLayout singlePage() {
        return new MultiPageLayout(0, 0, 0.0f, 0.0f);
    }

    public final Color getBackColor() {
        return this.zzWEt.zz6s();
    }

    public final void setBackColor(Color value) {
        this.zzWEt = zzVQF.zzXDk(value);
    }

    public final Color getBorderColor() {
        return this.zzZ5G.zz6s();
    }

    public final void setBorderColor(Color value) {
        this.zzZ5G = zzVQF.zzXDk(value);
    }

    public final float getBorderWidth() {
        return this.zzYiq;
    }

    public final void setBorderWidth(float value) {
        if (value < 0.0f) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: Border width must be non-negative.");
        }
        this.zzYiq = value;
    }

    final int zzqG() {
        return this.zzWNu;
    }

    final int getColumns() {
        return this.zzYwD;
    }

    final float zzLz() {
        return this.zzZEZ;
    }

    final float zzYyU() {
        return this.zzZmc;
    }

    final zzVQF zzNC() {
        return this.zzWEt;
    }

    final zzVQF zzYTf() {
        return this.zzZ5G;
    }

    final boolean zza3() {
        return !zzVQF.zzYRf(this.zzZ5G, zzVQF.zzZiq) && this.zzYiq > 0.0f;
    }
}

