/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.NodeChangingArgs;
import com.aspose.words.NodeCollection;
import com.aspose.words.NodeList;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SmartTag;
import com.aspose.words.internal.zzWJv;
import com.aspose.words.zzDZ;
import com.aspose.words.zzP6;
import com.aspose.words.zzX1K;
import com.aspose.words.zzXUC;
import com.aspose.words.zzXnA;
import com.aspose.words.zzYAn;
import com.aspose.words.zzZFg;
import com.aspose.words.zzZXT;
import java.util.Iterator;

public abstract class CompositeNode<V extends Node>
extends Node
implements zzZXT,
Iterable<V> {
    private Node zzZhz;
    private Node zzvu;
    private Node zzYEp;

    protected CompositeNode() {
    }

    protected CompositeNode(DocumentBase doc) {
        super(doc);
    }

    protected void coreRemoveSelfOnly() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("This node is not attached to any document");
        }
        zzP6 zzP62 = new zzP6(this.getDocument());
        try {
            while (this.hasChildNodes()) {
                this.getParentNode().insertAfter(this.getLastChild(), this);
            }
            this.getParentNode().zzX6U(this, true);
            return;
        }
        finally {
            zzP62.dispose();
        }
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    public boolean hasChildNodes() {
        return this.getLastChild() != null;
    }

    final boolean zzZJD() {
        return this.zzXD4() != null;
    }

    final boolean zzVZT() {
        return this.hasChildNodes() && this.getFirstChild() == this.getLastChild();
    }

    final boolean zzXeA() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node instanceof zzDZ) {
                return true;
            }
            CompositeNode compositeNode = zzWJv.zzXDk((Object)node, CompositeNode.class);
            if (compositeNode == null || !compositeNode.zzXeA()) continue;
            return true;
        }
        return false;
    }

    public Node getFirstChild() {
        return this.zzZhz;
    }

    public Node getLastChild() {
        return this.zzvu;
    }

    final Node zzXD4() {
        return zzXUC.zzYAx(this.getFirstChild(), false);
    }

    final Node zzZPH() {
        return zzXUC.zzXFB(this.getLastChild(), false);
    }

    final CompositeNode zzZw9() {
        return (CompositeNode)zzXUC.zzYAx(this.getFirstChild(), true);
    }

    final CompositeNode zzB() {
        return (CompositeNode)zzXUC.zzXFB(this.getLastChild(), true);
    }

    final Node zzY3q() {
        Node node;
        Node node2;
        for (node2 = this.getFirstChild(); node2 != null && zzXUC.zzXK((node = node2).getNodeType()); node2 = node2.getNextSibling()) {
        }
        return node2;
    }

    final Node zzb0() {
        Node node;
        Node node2;
        for (node2 = this.getLastChild(); node2 != null && zzXUC.zzXK((node = node2).getNodeType()); node2 = node2.getPreviousSibling()) {
        }
        return node2;
    }

    public int getCount() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            ++n;
        }
        return n;
    }

    @Override
    Node zzXDk(boolean bl, zzYAn zzYAn2) {
        CompositeNode compositeNode = (CompositeNode)super.zzXDk(bl, zzYAn2);
        ((CompositeNode)super.zzXDk(bl, zzYAn2)).zzvu = null;
        compositeNode.zzZhz = null;
        if (bl) {
            for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                compositeNode.zzYT7(node.zzXDk(true, zzYAn2));
            }
        }
        return compositeNode;
    }

    @Override
    public String getText() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzXzs(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    final void zzXzs(StringBuilder stringBuilder) {
        this.zzY0d(stringBuilder);
        zzWJv.zzaQ(stringBuilder, this.zzZDH());
    }

    public NodeCollection getChildNodes(int nodeType, boolean isDeep) {
        return new NodeCollection(this, nodeType, isDeep);
    }

    final NodeCollection zzaQ(int[] nArray, boolean bl) {
        return new NodeCollection(this, nArray, bl);
    }

    public Node getChild(int nodeType, int index, boolean isDeep) {
        if (index >= 0 && !isDeep) {
            Node node;
            int n = index + 1;
            boolean bl = zzXUC.zzaF(nodeType);
            Node node2 = node = bl ? this.zzXD4() : this.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == nodeType || nodeType == 0) {
                    --n;
                }
                if (n == 0) {
                    return node;
                }
                node = bl ? node.zzWRD() : node.getNextSibling();
            }
        } else {
            NodeCollection nodeCollection = this.getChildNodes(nodeType, isDeep);
            return nodeCollection.get(index);
        }
        return null;
    }

    public NodeList selectNodes(String xpath) {
        return zzXUC.zzWew((Node)this, xpath);
    }

    public Node selectSingleNode(String xpath) {
        return zzXUC.zzX6U((Node)this, xpath);
    }

    @Override
    public Iterator<V> iterator() {
        return new zzXnA(this);
    }

    public <T extends Node> T appendChild(T newChild) {
        return this.insertAfter(newChild, this.getLastChild());
    }

    public <T extends Node> T prependChild(T newChild) {
        return this.insertBefore(newChild, this.getFirstChild());
    }

    public <T extends Node> T insertAfter(T newChild, Node refChild) {
        return this.zzXDk(newChild, refChild, true);
    }

    public <T extends Node> T insertBefore(T newChild, Node refChild) {
        return this.zzXDk(newChild, refChild, false);
    }

    public <T extends Node> T removeChild(T oldChild) {
        return this.zzX6U(oldChild, false);
    }

    private <T extends Node> T zzX6U(T t, boolean bl) {
        if (t == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oldChild");
        }
        if (t.getParentNode() != this) {
            throw new IllegalArgumentException("This node is not a parent of the oldChild node.");
        }
        DocumentBase documentBase = this.getDocument();
        NodeChangingArgs nodeChangingArgs = zzXUC.zzXDk(documentBase, t, (Node)this, null, 1);
        DocumentBase documentBase2 = documentBase;
        if (documentBase2.zzZ1g() && zzXUC.zzWMo(t)) {
            return t;
        }
        zzXUC.zzXDk(documentBase, nodeChangingArgs);
        if (!bl && zzXUC.zz2O(t)) {
            zzXUC.zzWE0(t, false);
        }
        T t2 = this.zzXDX(t);
        zzXUC.zzaQ(documentBase, nodeChangingArgs);
        return t2;
    }

    public void removeAllChildren() {
        zzX1K.zzY8Z(this.getFirstChild(), null);
    }

    public void removeSmartTags() {
        for (SmartTag smartTag : this.getChildNodes(27, true)) {
            smartTag.coreRemoveSelfOnly();
        }
    }

    final Node zzYT7(Node node) {
        node.getParentNode();
        if (this.zzvu == null) {
            node.zzQm(null);
            node.zzBv(null);
            this.zzZhz = node;
        } else {
            node.zzQm(this.zzvu);
            node.zzBv(null);
            this.zzvu.zzBv(node);
        }
        this.zzvu = node;
        node.zzYfb(this);
        return node;
    }

    final void zzXDk(Node node, Node node2, Node node3) {
        this.zzXDk(node, node2, node3, false);
    }

    final void zzXDk(Node node, Node node2, Node node3, boolean bl) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            if (!bl || this.zzXcI(node4)) {
                this.insertBefore(node4, node3);
            }
            node4 = node5;
        }
    }

    final void zzaQ(Node node, Node node2, Node node3) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            node3 = this.insertAfter(node4, node3);
            node4 = node5;
        }
    }

    public int indexOf(Node child) {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node == child) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    final int zzYRf(Node node, boolean bl) {
        int n = 0;
        for (Node node2 = this.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            Node node3 = node2;
            if (zzXUC.zzXK(node3.getNodeType())) continue;
            if (zzXUC.zzYRf(node, node2)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    final int getTextLength() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            n += node.getTextLength();
        }
        return n += this.zzZDH().length();
    }

    String zzZDH() {
        return "";
    }

    final String zzWQf() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzY0d(stringBuilder);
        return stringBuilder.toString();
    }

    private void zzY0d(StringBuilder stringBuilder) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            node.zzXzs(stringBuilder);
        }
    }

    protected boolean acceptCore(DocumentVisitor visitor) throws Exception {
        switch (this.acceptStart(visitor)) {
            case 0: {
                break;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            default: {
                throw new IllegalStateException("Unknown visitor action.");
            }
        }
        if (!this.acceptChildren(visitor)) {
            return false;
        }
        return CompositeNode.visitorActionToBool(this.acceptEnd(visitor));
    }

    public abstract int acceptStart(DocumentVisitor var1) throws Exception;

    public abstract int acceptEnd(DocumentVisitor var1) throws Exception;

    protected boolean acceptChildren(DocumentVisitor visitor) throws Exception {
        Node node = this.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (!node.accept(visitor)) {
                return false;
            }
            node = node2;
        }
        return true;
    }

    boolean zzXcI(Node node) {
        return true;
    }

    final <T extends Node> T zzXDk(T t, Node node, boolean bl) {
        Object object;
        if (node != null && node.getParentNode() != this) {
            throw new IllegalArgumentException("The reference node is not a child of this node.");
        }
        if (t == null) {
            throw new IllegalArgumentException("Cannot insert a null node.");
        }
        if (t == this) {
            throw new IllegalArgumentException("Cannot add a node to self.");
        }
        if (this.zzVX(t)) {
            throw new IllegalArgumentException("The newChild is an ancestor of this node.");
        }
        if (t == node) {
            throw new IllegalArgumentException("Cannot add a node before/after itself.");
        }
        DocumentBase documentBase = this.getDocument();
        DocumentBase documentBase2 = t.getDocument();
        zzXUC.zzXDk(documentBase, documentBase2);
        if (t.getNodeType() != 37 && !this.zzXcI(t)) {
            throw new IllegalArgumentException("Cannot insert a node of this type at this location.");
        }
        CompositeNode compositeNode = t.getParentNode();
        Node node2 = t.getNextSibling();
        if (compositeNode != null) {
            object = new zzZFg(documentBase);
            try {
                compositeNode.zzX6U(t, true);
            }
            finally {
                ((zzZFg)object).dispose();
            }
        }
        object = zzXUC.zzXDk(documentBase, t, null, (Node)this, 0);
        zzXUC.zzXDk(documentBase, (NodeChangingArgs)object);
        if (this.zzvu == null) {
            t.zzQm(null);
            t.zzBv(null);
            this.zzZhz = t;
            this.zzvu = t;
        } else if (bl) {
            if (node != null) {
                this.zzaQ(t, node);
            } else {
                this.zzWew(t, this.zzZhz);
            }
        } else if (node != null) {
            this.zzWew(t, node);
        } else {
            this.zzaQ(t, this.zzvu);
        }
        t.zzYfb(this);
        zzXUC.zzaQ(documentBase, (NodeChangingArgs)object);
        DocumentBase documentBase3 = documentBase;
        if (documentBase3.zzZ1g()) {
            zzXUC.zzXDk(t, compositeNode, node2);
        }
        return t;
    }

    private void zzaQ(Node node, Node node2) {
        Node node3 = node2.zz1A();
        node.zzQm(node2);
        node.zzBv(node3);
        node2.zzBv(node);
        if (node3 == null) {
            this.zzvu = node;
            return;
        }
        node3.zzQm(node);
    }

    private void zzWew(Node node, Node node2) {
        Node node3 = node2.zz3y();
        node.zzQm(node3);
        node.zzBv(node2);
        node2.zzQm(node);
        if (node3 == null) {
            this.zzZhz = node;
            return;
        }
        node3.zzBv(node);
    }

    private <T extends Node> T zzXDX(T t) {
        if (t == this.zzZhz) {
            if (this.zzZhz == this.zzvu) {
                this.zzZhz = null;
                this.zzvu = null;
            } else {
                this.zzZhz = t.zz1A();
                this.zzZhz.zzQm(null);
            }
        } else {
            Node node = t.zz3y();
            Node node2 = t.zz1A();
            node.zzBv(node2);
            if (node2 == null) {
                this.zzvu = node;
            } else {
                node2.zzQm(node);
            }
        }
        t.zzBv(null);
        t.zzQm(null);
        t.zzYfb(null);
        return t;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Node curNode) {
        Node node = curNode;
        this.zzYEp = curNode == this ? this.getFirstChild() : curNode.getNextSibling();
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getCurrentNode() {
        return this.zzYEp;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this;
    }
}

