/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Border;
import com.aspose.words.internal.zzVQF;
import com.aspose.words.internal.zzWJv;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzeh;
import java.awt.Color;
import java.util.Iterator;

public final class BorderCollection
implements Iterable<Border> {
    private zzeh zzXBb;

    BorderCollection(zzeh parent) {
        this.zzXBb = parent;
    }

    public final boolean equals(BorderCollection brColl) throws Exception {
        if (zzWJv.zzZuV(this, brColl)) {
            return true;
        }
        return this.getLeft().equals(brColl.getLeft()) && this.getRight().equals(brColl.getRight()) && this.getTop().equals(brColl.getTop()) && this.getBottom().equals(brColl.getBottom()) && this.getHorizontal().equals(brColl.getHorizontal()) && this.getVertical().equals(brColl.getVertical()) && this.getColor().equals(brColl.getColor()) && this.zz23().equals(brColl.zz23()) && this.getDistanceFromText() == brColl.getDistanceFromText() && this.getLineWidth() == brColl.getLineWidth() && this.getLineStyle() == brColl.getLineStyle() && this.getCount() == brColl.getCount() && this.getShadow() == brColl.getShadow() && this.isVisible() == brColl.isVisible();
    }

    public final Border getByBorderType(int borderType) throws Exception {
        RefInt refInt = new RefInt(0);
        boolean bl = !this.zzXBb.getPossibleBorderKeys().zzXDk(borderType, refInt);
        int borderKey = refInt.get();
        if (bl) {
            throw new IllegalStateException("The requested border is not available for this object.");
        }
        Border border = (Border)this.zzXBb.getDirectBorderAttr(borderKey);
        if (border == null) {
            border = new Border(this.zzXBb, borderKey);
            this.zzXBb.setBorderAttr(borderKey, border);
        }
        return border;
    }

    public final Border get(int index) throws Exception {
        int n = this.zzXBb.getPossibleBorderKeys().zzYNJ().get(index);
        return this.getByBorderType(n);
    }

    public final Border getLeft() throws Exception {
        return this.getByBorderType(1);
    }

    public final Border getRight() throws Exception {
        return this.getByBorderType(2);
    }

    public final Border getTop() throws Exception {
        return this.getByBorderType(3);
    }

    public final Border getBottom() throws Exception {
        return this.getByBorderType(0);
    }

    public final Border getHorizontal() throws Exception {
        return this.getByBorderType(4);
    }

    public final Border getVertical() throws Exception {
        return this.getByBorderType(5);
    }

    public final int getCount() {
        return this.zzXBb.getPossibleBorderKeys().getCount();
    }

    public final double getLineWidth() throws Exception {
        return this.get(0).getLineWidth();
    }

    public final void setLineWidth(double value) throws Exception {
        Iterator iterator = this.zzXBb.getPossibleBorderKeys().zzYNJ().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzWKk(n)) continue;
            this.getByBorderType(n).setLineWidth(value);
        }
    }

    public final int getLineStyle() throws Exception {
        return this.get(0).getLineStyle();
    }

    public final void setLineStyle(int value) throws Exception {
        Iterator iterator = this.zzXBb.getPossibleBorderKeys().zzYNJ().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzWKk(n)) continue;
            this.getByBorderType(n).setLineStyle(value);
        }
    }

    public final Color getColor() throws Exception {
        return this.zz23().zz6s();
    }

    public final void setColor(Color value) throws Exception {
        this.zzXDL(zzVQF.zzXDk(value));
    }

    private zzVQF zz23() throws Exception {
        return this.get(0).zz23();
    }

    private void zzXDL(zzVQF zzVQF2) throws Exception {
        Iterator iterator = this.zzXBb.getPossibleBorderKeys().zzYNJ().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzWKk(n)) continue;
            this.getByBorderType(n).zzXDL(zzVQF2);
        }
    }

    final boolean zzYoM(int n) {
        return this.zzXBb.getPossibleBorderKeys().zzY0j(n);
    }

    public final double getDistanceFromText() throws Exception {
        return this.get(0).getDistanceFromText();
    }

    public final void setDistanceFromText(double value) throws Exception {
        Iterator iterator = this.zzXBb.getPossibleBorderKeys().zzYNJ().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzWKk(n)) continue;
            this.getByBorderType(n).setDistanceFromText(value);
        }
    }

    public final boolean getShadow() throws Exception {
        return this.get(0).getShadow();
    }

    public final void setShadow(boolean value) throws Exception {
        Iterator iterator = this.zzXBb.getPossibleBorderKeys().zzYNJ().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzWKk(n)) continue;
            this.getByBorderType(n).setShadow(value);
        }
    }

    public final void clearFormatting() {
        for (Border border : this) {
            border.clearFormatting();
        }
    }

    @Override
    public final Iterator<Border> iterator() {
        return new zzXDk(this);
    }

    final boolean isVisible() {
        for (Border border : this) {
            if (!border.isVisible()) continue;
            return true;
        }
        return false;
    }

    private static boolean zzWKk(int n) {
        return n != 6 && n != 7;
    }

    static final class zzXDk
    implements Iterator<Border> {
        private BorderCollection zzW1R;
        private int zzlp;

        zzXDk(BorderCollection borderCollection) {
            this.zzW1R = borderCollection;
            this.zzlp = -1;
        }

        @Override
        public final boolean hasNext() {
            if (this.zzlp >= this.zzW1R.getCount() - 1) {
                return false;
            }
            ++this.zzlp;
            return true;
        }

        private Border zzY7t() {
            try {
                return this.zzW1R.get(this.zzlp);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final /* synthetic */ Object next() {
            return this.zzY7t();
        }
    }
}

