/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzZWZ;
import com.aspose.words.net.System.Data.Constraint;
import com.aspose.words.net.System.Data.ConstraintCollection;
import com.aspose.words.net.System.Data.DBNull;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataKey;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataSet;
import com.aspose.words.net.System.Data.DataTable;
import com.aspose.words.net.System.Data.ForeignKeyConstraint;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.UniqueConstraint;
import com.aspose.words.net.System.Data.zzW3X;

public class DataRelation {
    private DataKey zzZM;
    private DataKey zzWHH;
    private String zzZik;
    private String zzZN8;
    private String zzXQe;
    private String[] zzYdf;
    private String[] zzXOp;
    private DataColumn[] zzg5;
    private DataColumn[] zzII;
    private UniqueConstraint zzYXd;
    private ForeignKeyConstraint zzZiJ;
    private boolean zzYy2 = true;
    private DataSet zzVTr;

    public DataRelation(String relationName, DataTable parentTable, DataTable childTable, String[] parentColumnNames, String[] childColumnNames) {
        DataColumn[] dataColumnArray = DataRelation.zzYxS(parentTable, parentColumnNames);
        DataColumn[] dataColumnArray2 = DataRelation.zzYxS(childTable, childColumnNames);
        this.zzWBj(relationName, dataColumnArray, dataColumnArray2, true);
    }

    public DataRelation(String relationName, DataColumn[] parentColumns, DataColumn[] childColumns, boolean createConstraints) {
        this.zzWBj(relationName, parentColumns, childColumns, createConstraints);
    }

    public DataRelation(String relationName, DataColumn parentColumn, DataColumn childColumn, boolean createConstraint) {
        this(relationName, new DataColumn[]{parentColumn}, new DataColumn[]{childColumn}, createConstraint);
    }

    public DataRelation(String relationName, DataColumn parentColumn, DataColumn childColumn) {
        this(relationName, new DataColumn[]{parentColumn}, new DataColumn[]{childColumn}, true);
    }

    private static DataColumn[] zzYxS(DataTable dataTable, String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("Column names need to have at least one column name.");
        }
        if (dataTable == null) {
            throw new IllegalArgumentException("Table cannot be null");
        }
        DataColumn[] dataColumnArray = new DataColumn[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            DataColumn dataColumn = dataTable.getColumns().get(stringArray[i]);
            if (dataColumn == null) {
                throw new IllegalArgumentException(zzZWZ.zzYxS("The given column {0} does not exist in {1}", stringArray[i], dataTable.getTableName()));
            }
            dataColumnArray[i] = dataColumn;
        }
        return dataColumnArray;
    }

    private void zzWBj(String string, DataColumn[] dataColumnArray, DataColumn[] dataColumnArray2, boolean bl) {
        int n;
        DataColumn dataColumn;
        int n2;
        if (dataColumnArray == null) {
            throw new IllegalArgumentException("parentColumns");
        }
        if (dataColumnArray2 == null) {
            throw new IllegalArgumentException("childColumns");
        }
        if (dataColumnArray.length != dataColumnArray2.length) {
            throw new IllegalArgumentException("Key Length mismatch");
        }
        DataTable dataTable = dataColumnArray[0].getTable();
        DataTable dataTable2 = dataColumnArray2[0].getTable();
        if (dataTable.getDataSet() != dataTable2.getDataSet()) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < dataColumnArray.length; ++i) {
            if (dataColumnArray[i].getTable().getDataSet() != null && dataColumnArray2[i].getTable().getDataSet() != null) continue;
            throw new IllegalArgumentException("Parent or Child columns do not have DataSet");
        }
        DataColumn[] dataColumnArray3 = dataColumnArray;
        int n3 = dataColumnArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            dataColumn = dataColumnArray3[n2];
            if (dataColumn.getTable() == dataTable) continue;
            throw new IllegalStateException();
        }
        dataColumnArray3 = dataColumnArray2;
        n3 = dataColumnArray2.length;
        for (n2 = 0; n2 < n3; ++n2) {
            dataColumn = dataColumnArray3[n2];
            if (dataColumn.getTable() == dataTable2) continue;
            throw new IllegalStateException();
        }
        for (n = 0; n < dataColumnArray2.length; ++n) {
            if (dataColumnArray[n].zzYxS(dataColumnArray2[n])) continue;
            throw new IllegalStateException("Parent Columns and Child Columns don't have matching column types");
        }
        this.zzg5 = dataColumnArray;
        this.zzII = dataColumnArray2;
        this.zzZik = string == null ? "" : string;
        this.zzYy2 = bl;
        this.zzWHH = new DataKey(dataColumnArray, true);
        this.zzZM = new DataKey(dataColumnArray2, true);
        this.zzVTr = dataTable.getDataSet();
        this.zzYdf = new String[this.zzg5.length];
        for (n = 0; n < this.zzg5.length; ++n) {
            this.zzYdf[n] = this.zzg5[n].getColumnName();
        }
        this.zzXOp = new String[this.zzII.length];
        for (n = 0; n < this.zzII.length; ++n) {
            this.zzXOp[n] = this.zzII[n].getColumnName();
        }
    }

    public String getRelationName() {
        return this.zzZik;
    }

    public String getParentTableName() {
        DataTable dataTable = this.getParentTable();
        if (dataTable != null) {
            return dataTable.getTableName();
        }
        return null;
    }

    public String getChildTableName() {
        DataTable dataTable = this.getChildTable();
        if (dataTable != null) {
            return dataTable.getTableName();
        }
        return null;
    }

    public DataTable getParentTable() {
        return this.getParentKey().getTable();
    }

    public DataTable getChildTable() {
        return this.getChildKey().getTable();
    }

    public String[] getParentColumnNames() {
        return this.zzYdf;
    }

    public String[] getChildColumnNames() {
        return this.zzXOp;
    }

    public DataColumn[] getParentColumns() {
        return this.zzg5;
    }

    public DataColumn[] getChildColumns() {
        return this.zzII;
    }

    public void setNested(boolean nested) {
    }

    public UniqueConstraint getParentKeyConstraint() {
        return this.zzYXd;
    }

    public void setParentKeyConstraint(UniqueConstraint parentKeyConstraint) {
        this.zzYXd = parentKeyConstraint;
    }

    public ForeignKeyConstraint getChildKeyConstraint() {
        return this.zzZiJ;
    }

    public void setChildKeyConstraint(ForeignKeyConstraint childKeyConstraint) {
        this.zzZiJ = childKeyConstraint;
    }

    public DataKey getChildKey() {
        return this.zzZM;
    }

    public DataKey getParentKey() {
        return this.zzWHH;
    }

    public DataSet getDataSet() {
        return this.zzVTr;
    }

    public int hashCode() {
        int n = 31 + this.zzZik.hashCode();
        n = n * 31 + this.zzZN8.hashCode();
        n = n * 31 + this.zzXQe.hashCode();
        for (int i = 0; i < this.zzYdf.length; ++i) {
            n = n * 31 + this.zzYdf[i].hashCode();
            n = n * 31 + this.zzXOp[i].hashCode();
        }
        return n;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DataRelation)) {
            return false;
        }
        DataRelation dataRelation = (DataRelation)obj;
        boolean bl = this.getRelationName().equals(dataRelation.getRelationName()) && this.getParentTableName().equals(dataRelation.getParentTableName()) && this.getChildTableName().equals(dataRelation.getChildTableName());
        if (!bl) {
            return false;
        }
        if (this.getParentColumnNames().length != dataRelation.getParentColumnNames().length || this.getChildColumnNames().length != dataRelation.getChildColumnNames().length) {
            return false;
        }
        for (int i = 0; i < this.getParentColumnNames().length; ++i) {
            if (this.getParentColumnNames()[i].equals(dataRelation.getParentColumnNames()[i]) && this.getChildColumnNames()[i].equals(dataRelation.getChildColumnNames()[i])) continue;
            return false;
        }
        return true;
    }

    static DataRow[] zzWBj(DataKey dataKey, DataKey dataKey2, DataRow dataRow) {
        Object[] objectArray = dataRow.getKeyValues(dataKey2);
        if (DataRelation.zzoC(objectArray)) {
            return new DataRow[0];
        }
        zzW3X zzW3X2 = dataKey.getSortIndex();
        return zzW3X2.zzXtm(objectArray);
    }

    private static boolean zzoC(Object[] objectArray) {
        if (objectArray == null) {
            return true;
        }
        Object[] objectArray2 = objectArray;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Object object = objectArray2[i];
            if (DataRelation.zzDy(object)) continue;
            return false;
        }
        return true;
    }

    private static boolean zzDy(Object object) {
        return object == null || DBNull.Value == object;
    }

    final void zz01() throws InvalidConstraintException, DataException {
        if (!this.zzYy2) {
            return;
        }
        DataRelation dataRelation = this;
        ForeignKeyConstraint foreignKeyConstraint = dataRelation.zzZON(dataRelation.getChildTable().getConstraints());
        DataRelation dataRelation2 = this;
        UniqueConstraint uniqueConstraint = dataRelation2.zzYxS(dataRelation2.getParentTable().getConstraints());
        if (uniqueConstraint == null) {
            uniqueConstraint = new UniqueConstraint(this.getParentColumns(), false);
            this.getParentTable().getConstraints().add(uniqueConstraint);
        }
        if (foreignKeyConstraint == null) {
            foreignKeyConstraint = new ForeignKeyConstraint(this.getRelationName(), this.getParentColumns(), this.getChildColumns());
            this.getChildTable().getConstraints().add(foreignKeyConstraint);
        }
        this.setParentKeyConstraint(uniqueConstraint);
        this.setChildKeyConstraint(foreignKeyConstraint);
    }

    private UniqueConstraint zzYxS(ConstraintCollection constraintCollection) {
        for (Constraint constraint : constraintCollection) {
            if (!(constraint instanceof UniqueConstraint)) continue;
            UniqueConstraint uniqueConstraint = (UniqueConstraint)constraint;
            if (!DataRelation.zzWBj(this.getParentColumns(), uniqueConstraint.getColumns())) continue;
            return uniqueConstraint;
        }
        return null;
    }

    private ForeignKeyConstraint zzZON(ConstraintCollection constraintCollection) {
        for (Constraint constraint : constraintCollection) {
            if (!(constraint instanceof ForeignKeyConstraint)) continue;
            ForeignKeyConstraint foreignKeyConstraint = (ForeignKeyConstraint)constraint;
            if (!DataRelation.zzWBj(this.getChildColumns(), foreignKeyConstraint.getColumns()) || !DataRelation.zzWBj(this.getParentColumns(), foreignKeyConstraint.getRelatedColumns())) continue;
            return foreignKeyConstraint;
        }
        return null;
    }

    private static boolean zzWBj(DataColumn[] dataColumnArray, DataColumn[] dataColumnArray2) {
        if (dataColumnArray.length != dataColumnArray2.length) {
            return false;
        }
        for (int i = 0; i < dataColumnArray.length; ++i) {
            DataColumn dataColumn = dataColumnArray[i];
            DataColumn dataColumn2 = dataColumnArray2[i];
            if (dataColumn.getColumnName().equals(dataColumn2.getColumnName()) && dataColumn.getDataType() == dataColumn2.getDataType() && dataColumn.getTable().getTableName().equals(dataColumn2.getTable().getTableName())) continue;
            return false;
        }
        return true;
    }
}

