/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.HeaderFooter;
import com.aspose.words.HeaderFooterCollection;
import com.aspose.words.Node;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.Shape;
import com.aspose.words.Story;
import com.aspose.words.internal.zzZP5;
import com.aspose.words.internal.zzZWZ;
import com.aspose.words.zzXkU;
import com.aspose.words.zzZ73;
import com.aspose.words.zzxr;

public final class Section
extends CompositeNode<Node>
implements zzxr {
    private zzZ73 zz7n;
    private PageSetup zzWNo;
    private HeaderFooterCollection zzZ70;

    public Section(DocumentBase doc) {
        this(doc, new zzZ73());
    }

    Section(DocumentBase doc, zzZ73 sectPr) {
        super(doc);
        this.zz7n = sectPr;
    }

    @Override
    public final int getNodeType() {
        return 2;
    }

    public final Body getBody() {
        return (Body)this.getChild(3, 0, false);
    }

    public final HeaderFooterCollection getHeadersFooters() {
        if (this.zzZ70 == null) {
            this.zzZ70 = new HeaderFooterCollection(this);
        }
        return this.zzZ70;
    }

    public final PageSetup getPageSetup() {
        if (this.zzWNo == null) {
            Section section = this;
            this.zzWNo = new PageSetup(section, section.getDocument().zzZP1(), this.getDocument().getStyles(), new zzWBj(this));
        }
        return this.zzWNo;
    }

    public final boolean getProtectedForForms() {
        return !this.getPageSetup().zzXdO();
    }

    public final void setProtectedForForms(boolean value) {
        this.getPageSetup().zzYGp(!value);
    }

    final zzZ73 zzZFV() {
        return this.zz7n;
    }

    final void zzZON(zzZ73 zzZ732) {
        this.zz7n = zzZ732;
    }

    public final Section deepClone() {
        return (Section)this.deepClone(true);
    }

    @Override
    final Node zzWBj(boolean bl, zzXkU zzXkU2) {
        zzZ73 zzZ732;
        Section section = (Section)super.zzWBj(bl, zzXkU2);
        zzZ73 zzZ733 = this.zz7n;
        section.zz7n = zzZ732 = (zzZ73)zzZ733.zzWlR();
        section.zzWNo = null;
        section.zzZ70 = null;
        return section;
    }

    @Override
    public final boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    final int zzWBj(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitSectionStart(this);
    }

    @Override
    final int zzYxS(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitSectionEnd(this);
    }

    public final void prependContent(Section sourceSection) {
        this.zzZdS(sourceSection, false);
    }

    public final void appendContent(Section sourceSection) {
        this.zzZdS(sourceSection, true);
    }

    public final void clearContent() {
        this.clearHeadersFooters();
        this.getBody().removeAllChildren();
        this.getBody().ensureMinimum();
    }

    public final void clearHeadersFooters() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).removeAllChildren();
        }
    }

    public final void deleteHeaderFooterShapes() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).deleteShapes();
        }
    }

    public final void ensureMinimum() {
        Body body = this.getBody();
        if (body == null) {
            body = (Body)this.appendChild(new Body(this.getDocument()));
        }
        body.ensureMinimum();
    }

    final Story zzYSY(int n) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (((Story)node).getStoryType() != n) continue;
            return (Story)node;
        }
        return null;
    }

    @Override
    final boolean zzX6s(Node node) {
        switch (node.getNodeType()) {
            case 3: 
            case 4: {
                int n = ((Story)node).getStoryType();
                return this.zzYSY(n) == null;
            }
        }
        return false;
    }

    final void zzZON(Shape shape, boolean bl) throws Exception {
        this.zzWBj(shape, 4, bl);
        this.zzWBj(shape, 0, bl);
        this.zzWBj(shape, 1, bl);
    }

    private void zzWBj(Shape shape, int n, boolean bl) throws Exception {
        HeaderFooter headerFooter = this.getHeadersFooters().getByHeaderFooterType(n);
        if (headerFooter == null) {
            if (!bl) {
                return;
            }
            headerFooter = new HeaderFooter(this.getDocument(), n);
            this.getHeadersFooters().add(headerFooter);
        }
        if (headerFooter.getParagraphs().getCount() == 0) {
            headerFooter.appendChild(new Paragraph(this.getDocument()));
        }
        Shape shape2 = (Shape)shape.deepClone(true);
        shape2.setId(shape2.getDocument().zzZvK());
        shape2.setName(zzZWZ.zzYxS("{0}{1}", shape2.hasImage() ? "WordPictureWatermark" : "PowerPlusWaterMarkObject", shape2.getId()));
        headerFooter.getFirstParagraph().appendChild(shape2);
    }

    final void zzY7J() {
        for (HeaderFooter headerFooter : this.getHeadersFooters()) {
            if (!headerFooter.isHeader()) continue;
            for (Shape shape : headerFooter.zzZVt()) {
                if (!shape.zzZZ6()) continue;
                shape.remove();
            }
        }
    }

    private void zzZdS(Section section, boolean bl) {
        Paragraph paragraph;
        if (section == null) {
            throw new NullPointerException("sourceSection");
        }
        Body body = section.getBody();
        if (body == null) {
            return;
        }
        Body body2 = this.getBody();
        if (body2 == null) {
            body2 = (Body)this.appendChild(new Body(this.getDocument()));
        }
        body = (Body)this.getDocument().importNode(body, true);
        CompositeNode compositeNode = paragraph = bl ? body2.getLastParagraph() : null;
        while (compositeNode != null && paragraph.getParentNode() != body2) {
            compositeNode = paragraph.getParentNode();
        }
        body2.zzYxS(body.getFirstChild(), null, paragraph);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object getDirectSectionAttr(int key) {
        return this.zz7n.zzXte(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchInheritedSectionAttr(int key) {
        if (key == 2600) {
            return this.getDocument().zzZP1().zzVXc.zzX4H(key);
        }
        return zzZ73.zzXop(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchSectionAttr(int key) {
        Object object = this.getDirectSectionAttr(key);
        if (object != null) {
            return object;
        }
        return this.fetchInheritedSectionAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setSectionAttr(int key, Object value) {
        if (key == 2260 || key == 2270) {
            this.zz7n.remove(2090);
        }
        if (key == 2600) {
            this.getDocument().zzZP1().zzVXc.zzZEp(key, value);
            return;
        }
        this.zz7n.zzZEp(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void clearSectionAttrs() {
        this.zz7n.clear();
    }

    final boolean zzX5A() {
        return this.getParentNode().getFirstChild() == this;
    }

    final boolean zzEV() {
        return this.getParentNode().getLastChild() == this;
    }

    @Override
    public final String toString() {
        return super.toString();
    }

    static final class zzWBj
    implements zzxr {
        private Section zzXkc;

        zzWBj(Section section) {
            this.zzXkc = section;
        }

        @Override
        public final Object getDirectSectionAttr(int key) {
            return this.zzWIQ().getDirectSectionAttr(key);
        }

        @Override
        public final Object fetchInheritedSectionAttr(int key) {
            return this.zzWIQ().fetchInheritedSectionAttr(key);
        }

        @Override
        public final Object fetchSectionAttr(int key) {
            return this.zzWIQ().fetchSectionAttr(key);
        }

        @Override
        public final void setSectionAttr(int key, Object value) {
        }

        @Override
        public final void clearSectionAttrs() {
        }

        private zzxr zzWIQ() {
            Document document = zzZP5.zzWBj((Object)this.zzXkc.getDocument(), Document.class);
            if (document != null && document.getFirstSection() != null) {
                return document.getFirstSection();
            }
            return this.zzXkc;
        }
    }
}

