/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocSaveOptions;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.HtmlFixedSaveOptions;
import com.aspose.words.HtmlSaveOptions;
import com.aspose.words.IDocumentSavingCallback;
import com.aspose.words.ImageSaveOptions;
import com.aspose.words.MarkdownSaveOptions;
import com.aspose.words.OdtSaveOptions;
import com.aspose.words.OoxmlSaveOptions;
import com.aspose.words.PclSaveOptions;
import com.aspose.words.PdfSaveOptions;
import com.aspose.words.PsSaveOptions;
import com.aspose.words.RtfSaveOptions;
import com.aspose.words.SvgSaveOptions;
import com.aspose.words.TxtSaveOptions;
import com.aspose.words.WordML2003SaveOptions;
import com.aspose.words.XamlFixedSaveOptions;
import com.aspose.words.XamlFlowSaveOptions;
import com.aspose.words.XpsSaveOptions;
import com.aspose.words.internal.zzXri;
import com.aspose.words.internal.zzYY5;

public abstract class SaveOptions {
    private boolean zzFt;
    private IDocumentSavingCallback zzWH1;
    private boolean zz1j = true;
    private boolean zzXhu = false;
    private boolean zzFp = true;
    private boolean zzZe3;
    private String zzXbV;
    private boolean zzY5H;
    private boolean zzWUZ = false;
    private boolean zzZJd = true;
    private int zzZGI = 1;
    private int zzWME = 1;
    private int zzW6t = 0;
    private String zzZ4 = "";
    private boolean zzZx2 = true;
    private boolean zzWnl = true;
    private boolean zzYoo;
    private boolean zzYoc;
    private int zzY2W = 0;
    private boolean zzUI = true;
    private boolean zzOz = false;
    private boolean zzWJz = true;

    protected SaveOptions() {
    }

    public abstract int getSaveFormat();

    public abstract void setSaveFormat(int var1);

    boolean zzXC0() {
        return false;
    }

    boolean zzXVA() {
        return true;
    }

    public boolean getExportGeneratorName() {
        return this.zzFp;
    }

    public void setExportGeneratorName(boolean value) {
        this.zzFp = value;
    }

    public String getTempFolder() {
        return this.zzXbV;
    }

    public void setTempFolder(String value) {
        this.zzXbV = value;
    }

    public boolean getPrettyFormat() {
        return this.zzZe3;
    }

    public void setPrettyFormat(boolean value) {
        this.zzZe3 = value;
    }

    public boolean getUseAntiAliasing() {
        return this.zzY5H;
    }

    public void setUseAntiAliasing(boolean value) {
        this.zzY5H = value;
    }

    public boolean getUseHighQualityRendering() {
        return this.zzWUZ;
    }

    public void setUseHighQualityRendering(boolean value) {
        this.zzWUZ = value;
    }

    public boolean getUpdateSdtContent() {
        return this.zzZJd;
    }

    public void setUpdateSdtContent(boolean value) {
        this.zzZJd = value;
    }

    public int getDmlRenderingMode() {
        return this.zzZGI;
    }

    public void setDmlRenderingMode(int value) {
        this.zzZGI = value;
    }

    public int getDmlEffectsRenderingMode() {
        return this.zzW6t;
    }

    public void setDmlEffectsRenderingMode(int value) {
        this.zzW6t = value;
    }

    public int getImlRenderingMode() {
        return this.zzWME;
    }

    public void setImlRenderingMode(int value) {
        this.zzWME = value;
    }

    public String getDefaultTemplate() {
        return this.zzZ4;
    }

    public void setDefaultTemplate(String value) {
        this.zzZ4 = value;
    }

    public boolean getUpdateFields() {
        return this.zzZx2;
    }

    public void setUpdateFields(boolean value) {
        this.zzZx2 = value;
    }

    public boolean getUpdateLastSavedTimeProperty() {
        return this.zzYoo;
    }

    public void setUpdateLastSavedTimeProperty(boolean value) {
        this.zzYoo = value;
    }

    public boolean getUpdateLastPrintedProperty() {
        return this.zzYoc;
    }

    public void setUpdateLastPrintedProperty(boolean value) {
        this.zzYoc = value;
    }

    public boolean getUpdateCreatedTimeProperty() {
        return this.zzOz;
    }

    public void setUpdateCreatedTimeProperty(boolean value) {
        this.zzOz = value;
    }

    public boolean getMemoryOptimization() {
        return this.zzXhu;
    }

    public void setMemoryOptimization(boolean value) {
        this.zzXhu = value;
    }

    final boolean zzUa() {
        return this.zzWnl;
    }

    final boolean zzWvz() {
        return this.zzUI;
    }

    public static SaveOptions createSaveOptions(int saveFormat) {
        switch (saveFormat) {
            case 10: 
            case 11: {
                return new DocSaveOptions(saveFormat);
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return new OoxmlSaveOptions(saveFormat);
            }
            case 30: {
                return new RtfSaveOptions();
            }
            case 31: {
                return new WordML2003SaveOptions();
            }
            case 40: {
                return new PdfSaveOptions();
            }
            case 47: {
                return new PsSaveOptions();
            }
            case 48: {
                return new PclSaveOptions();
            }
            case 41: {
                return new XpsSaveOptions(41);
            }
            case 46: {
                return new XpsSaveOptions(46);
            }
            case 42: {
                return new XamlFixedSaveOptions();
            }
            case 44: {
                return new SvgSaveOptions();
            }
            case 45: {
                return new HtmlFixedSaveOptions();
            }
            case 50: 
            case 51: 
            case 52: {
                return new HtmlSaveOptions(saveFormat);
            }
            case 60: 
            case 61: {
                return new OdtSaveOptions(saveFormat);
            }
            case 70: {
                return new TxtSaveOptions();
            }
            case 71: {
                return new XamlFlowSaveOptions();
            }
            case 72: {
                return new XamlFlowSaveOptions(saveFormat);
            }
            case 73: {
                return new MarkdownSaveOptions();
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                return new ImageSaveOptions(saveFormat);
            }
        }
        throw new IllegalArgumentException("Invalid save format requested.");
    }

    public static SaveOptions createSaveOptions(String fileName) throws Exception {
        return SaveOptions.createSaveOptions(FileFormatUtil.zzWMZ(zzXri.zzYX1(zzYY5.zzYf0(fileName))));
    }

    public int getDml3DEffectsRenderingMode() {
        return this.zzY2W;
    }

    public void setDml3DEffectsRenderingMode(int value) {
        this.zzY2W = value;
    }

    public IDocumentSavingCallback getProgressCallback() {
        return this.zzWH1;
    }

    public void setProgressCallback(IDocumentSavingCallback value) {
        this.zzWH1 = value;
    }

    public boolean getAllowEmbeddingPostScriptFonts() {
        return this.zzFt;
    }

    public void setAllowEmbeddingPostScriptFonts(boolean value) {
        this.zzFt = value;
    }

    public boolean getFlatOpcXmlMappingOnly() {
        return this.zzWJz;
    }

    public void setFlatOpcXmlMappingOnly(boolean value) {
        this.zzWJz = value;
    }

    final boolean zzXL3() {
        return this.zz1j;
    }
}

