/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.Node;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.internal.zzfs;
import com.aspose.words.zzWE1;
import com.aspose.words.zzXcF;
import com.aspose.words.zzYID;
import com.aspose.words.zzYWn;
import java.util.ArrayList;
import java.util.Iterator;

public class NodeCollection<T extends Node>
implements zzXcF,
Iterable<T> {
    private Node zzav;
    private CompositeNode zzWwO;
    private DocumentBase zzWh1;
    private boolean zzYsp;
    private int zziK;
    private int zzZU3;
    private Node zzWAx;
    private int zzVYI;
    private zzWE1 zzWP;

    NodeCollection(CompositeNode container, int nodeType, boolean isDeep) {
        this(container, zzYWn.zzWKq(nodeType), isDeep);
    }

    NodeCollection(CompositeNode container, int[] nodeTypes, boolean isDeep) {
        this(container, new zzYWn(nodeTypes), isDeep);
    }

    NodeCollection(CompositeNode container, zzWE1 matcher, boolean isDeep) {
        if (container == null) {
            throw new NullPointerException("container");
        }
        if (matcher == null) {
            throw new NullPointerException("matcher");
        }
        this.zzWwO = container;
        this.zzWh1 = container.getDocument();
        this.zzWP = matcher;
        this.zzYsp = isDeep;
        this.zz9w();
    }

    public Node get(int index) {
        try {
            this.zzYpC();
            if (index < 0 && (index = this.getCount() + index) < 0) {
                return null;
            }
            if (this.zzZU3 == index) {
                return this.zzWAx;
            }
            int n = index - this.zzZU3;
            NodeCollection nodeCollection = this;
            Node node = nodeCollection.zzW6h(nodeCollection.zzWAx, n);
            if (node != null) {
                this.zzZU3 = index;
                this.zzWAx = node;
            }
            return node;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void add(Node node) {
        if (this.zzYsp) {
            throw new UnsupportedOperationException("Adding nodes is not yet supported for deep node collections.");
        }
        this.zzWwO.appendChild(node);
    }

    public void insert(int index, Node node) {
        if (this.zzYsp) {
            throw new UnsupportedOperationException("Inserting nodes is not yet supported for deep node collections.");
        }
        this.zzWwO.insertBefore(node, this.get(index));
    }

    public void remove(Node node) {
        node.remove();
    }

    public void removeAt(int index) {
        this.get(index).remove();
    }

    public void clear() {
        for (Node node : this) {
            node.remove();
        }
    }

    public boolean contains(Node node) {
        return this.indexOf(node) != -1;
    }

    public int indexOf(Node node) {
        int n = 0;
        for (Node node2 : this) {
            if (node == node2) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Node[] toArray() {
        Node[] nodeArray = new Node[]{};
        ArrayList arrayList = this.zzWej();
        return arrayList.toArray(nodeArray);
    }

    @Override
    public Iterator<T> iterator() {
        return new zzYID(this);
    }

    final <TNode extends Node> zzYID<TNode> zzZkY() {
        return new zzYID(this);
    }

    final <TValue extends Node> ArrayList<TValue> zzWej() {
        ArrayList arrayList = new ArrayList();
        for (Node node : this) {
            zzfs.zzWBj(arrayList, node);
        }
        return arrayList;
    }

    private Node zzW6h(Node node, int n) throws Exception {
        boolean bl;
        boolean bl2 = bl = n > 0;
        if (n < 0) {
            n = -n;
        }
        Node node2 = node;
        for (int i = 0; i < n; ++i) {
            if ((node2 = this.zzVSp(node2, bl)) != null) continue;
            return null;
        }
        return node2;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Node curNode) throws Exception {
        return this.zzZJo(curNode, true);
    }

    private Node zzZJo(Node node, boolean bl) throws Exception {
        Node node2;
        this.zzav = node;
        do {
            node2 = this.zzav;
            Node node3 = this.zzYsp ? this.zzWBj(true, this.zzav) : (this.zzav = this.zzWP.zzIm() ? this.zzZON(true, this.zzav) : this.zzYxS(true, this.zzav));
        } while (this.zzav != null && !this.zzWP.zzWxV(this.zzav));
        return node2;
    }

    private Node zzVSp(Node node, boolean bl) throws Exception {
        while ((this.zzYsp ? this.zzWBj(bl, node) : (node = this.zzWP.zzIm() ? this.zzZON(bl, node) : this.zzYxS(bl, node))) != null && !this.zzWP.zzWxV(node)) {
        }
        return node;
    }

    private Node zzWBj(boolean bl, Node node) {
        if (bl) {
            return node.nextPreOrder(this.zzWwO);
        }
        return node.previousPreOrder(this.zzWwO);
    }

    private Node zzYxS(boolean bl, Node node) {
        if (bl) {
            if (node == this.zzWwO) {
                return this.zzWwO.getFirstChild();
            }
            return node.getNextSibling();
        }
        if (node == this.zzWwO) {
            return this.zzWwO.getLastChild();
        }
        return node.getPreviousSibling();
    }

    private Node zzZON(boolean bl, Node node) {
        Node node2;
        if (bl) {
            node2 = node == this.zzWwO ? this.zzWwO.zzZQy() : node.zzWBV();
        } else {
            Node node3 = node2 = node == this.zzWwO ? this.zzWwO.zzXlu() : node.zz78();
        }
        if (node2 == this.zzWwO.getNextSibling() || node2 == this.zzWwO.getPreviousSibling()) {
            node2 = null;
        }
        return node2;
    }

    private void zzYpC() {
        if (this.zziK != this.zzZb7()) {
            this.zz9w();
        }
    }

    private void zz9w() {
        this.zziK = this.zzZb7();
        this.zzZU3 = -1;
        this.zzWAx = this.zzWwO;
        this.zzVYI = -1;
    }

    private int zzZb7() {
        if (this.zzWh1 != null) {
            return this.zzWh1.zzQu();
        }
        return 0;
    }

    public int getCount() {
        this.zzYpC();
        if (this.zzVYI == -1) {
            this.zzVYI = zzYID.zzWBj(this);
        }
        return this.zzVYI;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getCurrentNode() {
        return this.zzav;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this.zzWwO;
    }
}

