/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.Bookmark;
import com.aspose.words.BookmarkEnd;
import com.aspose.words.BookmarkStart;
import com.aspose.words.Border;
import com.aspose.words.Cell;
import com.aspose.words.CellFormat;
import com.aspose.words.CompatibilityOptions;
import com.aspose.words.CompositeNode;
import com.aspose.words.ControlChar;
import com.aspose.words.ConvertUtil;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.EditableRangeEnd;
import com.aspose.words.EditableRangeStart;
import com.aspose.words.Field;
import com.aspose.words.FieldEnd;
import com.aspose.words.FieldMergeField;
import com.aspose.words.FieldSeparator;
import com.aspose.words.FieldStart;
import com.aspose.words.Font;
import com.aspose.words.Footnote;
import com.aspose.words.FormField;
import com.aspose.words.HeaderFooter;
import com.aspose.words.ImageSize;
import com.aspose.words.ImportFormatOptions;
import com.aspose.words.Inline;
import com.aspose.words.ListFormat;
import com.aspose.words.Node;
import com.aspose.words.NodeCollection;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphFormat;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.ResourceLoadingArgs;
import com.aspose.words.Row;
import com.aspose.words.RowFormat;
import com.aspose.words.Run;
import com.aspose.words.Section;
import com.aspose.words.Shape;
import com.aspose.words.SignatureLineOptions;
import com.aspose.words.SpecialChar;
import com.aspose.words.Story;
import com.aspose.words.StructuredDocumentTag;
import com.aspose.words.Style;
import com.aspose.words.Table;
import com.aspose.words.internal.zz65;
import com.aspose.words.internal.zzFv;
import com.aspose.words.internal.zzW6p;
import com.aspose.words.internal.zzWkA;
import com.aspose.words.internal.zzWnH;
import com.aspose.words.internal.zzXLE;
import com.aspose.words.internal.zzXQZ;
import com.aspose.words.internal.zzXpm;
import com.aspose.words.internal.zzXrr;
import com.aspose.words.internal.zzYKG;
import com.aspose.words.internal.zzYNb;
import com.aspose.words.internal.zzYY5;
import com.aspose.words.internal.zzYhL;
import com.aspose.words.internal.zzZP5;
import com.aspose.words.internal.zzZRe;
import com.aspose.words.internal.zzZWZ;
import com.aspose.words.internal.zzZaD;
import com.aspose.words.internal.zzjb;
import com.aspose.words.zz0q;
import com.aspose.words.zz45;
import com.aspose.words.zz7b;
import com.aspose.words.zzFn;
import com.aspose.words.zzNz;
import com.aspose.words.zzPr;
import com.aspose.words.zzPt;
import com.aspose.words.zzSI;
import com.aspose.words.zzTV;
import com.aspose.words.zzVTc;
import com.aspose.words.zzWAq;
import com.aspose.words.zzWb4;
import com.aspose.words.zzWqZ;
import com.aspose.words.zzWs9;
import com.aspose.words.zzWw1;
import com.aspose.words.zzX77;
import com.aspose.words.zzX9u;
import com.aspose.words.zzXCv;
import com.aspose.words.zzXbZ;
import com.aspose.words.zzXf9;
import com.aspose.words.zzXi5;
import com.aspose.words.zzXy1;
import com.aspose.words.zzY6I;
import com.aspose.words.zzYGp;
import com.aspose.words.zzYKw;
import com.aspose.words.zzYOU;
import com.aspose.words.zzYWw;
import com.aspose.words.zzYcb;
import com.aspose.words.zzYeZ;
import com.aspose.words.zzYgW;
import com.aspose.words.zzYnh;
import com.aspose.words.zzYph;
import com.aspose.words.zzZ6R;
import com.aspose.words.zzZ73;
import com.aspose.words.zzZAE;
import com.aspose.words.zzZE4;
import com.aspose.words.zzZJo;
import com.aspose.words.zzZKw;
import com.aspose.words.zzZUE;
import com.aspose.words.zzZoq;
import com.aspose.words.zzZt0;
import com.aspose.words.zzZyA;
import com.aspose.words.zzaE;
import java.awt.image.BufferedImage;
import java.io.InputStream;

public class DocumentBuilder
implements zzWb4,
zzXCv,
zzZoq {
    private Document zzX32;
    private Node zzXZx;
    private Node zzWPQ;
    private zz45 zz5t;
    private Font zzYT3;
    private zz65<zz45> zzXEh;
    private zz65<zzWqZ> zzYFv;
    private zz65<zzWBj> zzX50;
    private zzX9u zzWI0 = zzX9u.zzXzG();
    private zzYOU zzVOI = new zzYOU();
    private RowFormat zzYSw;
    private CellFormat zzWHA;
    private zz65<zzPt> zzYiG;
    private int zzYXQ = 0;
    private int zzX11 = -1;
    private int zzwe;

    public DocumentBuilder() throws Exception {
        this.setDocument(new Document());
    }

    public DocumentBuilder(Document doc) {
        this.setDocument(doc);
    }

    public void moveToDocumentStart() {
        this.zzXtm(0, 1, 0, 0);
    }

    public void moveToDocumentEnd() {
        this.zzXtm(-1, 1, -1, -1);
        Footnote footnote = (Footnote)this.getCurrentParagraph().getAncestor(20);
        if (footnote != null) {
            this.moveTo(footnote.getParentParagraph());
        }
    }

    public void moveToSection(int sectionIndex) {
        this.zzXtm(sectionIndex, 1, 0, 0);
    }

    public void moveToHeaderFooter(int headerFooterType) {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzWBj(documentBuilder.getCurrentSection(), zzSI.zzYAG(headerFooterType), 0, 0);
    }

    private void zzXtm(int n, int n2, int n3, int n4) {
        this.zzX32.ensureMinimum();
        Section section = (Section)this.zzX32.getChild(2, n, false);
        if (section == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: sectionIdx");
        }
        this.zzWBj(section, 1, n3, n4);
    }

    private void zzWBj(Section section, int n, int n2, int n3) {
        Story story;
        section.ensureMinimum();
        if (n == 1) {
            story = section.getBody();
        } else {
            int n4 = zzSI.zzZNe(n);
            story = section.getHeadersFooters().getByHeaderFooterType(n4);
            if (story == null) {
                story = (HeaderFooter)section.appendChild(new HeaderFooter(this.zzX32, n4));
            }
            if (story.getFirstParagraph() == null) {
                story.appendChild(new Paragraph(this.zzX32));
            }
        }
        this.zzWBj(story, n2, n3);
    }

    private void zzWBj(Story story, int n, int n2) {
        Paragraph paragraph = (Paragraph)story.getChild(8, n, true);
        if (paragraph == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: paraIdx");
        }
        int n3 = n2;
        Paragraph paragraph2 = paragraph;
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzWBj((CompositeNode)paragraph2, n3);
    }

    final void zzWBj(Paragraph paragraph, int n) {
        this.zzWBj((CompositeNode)paragraph, n);
    }

    public boolean moveToMergeField(String fieldName) throws Exception {
        return this.moveToMergeField(fieldName, true, true);
    }

    public boolean moveToMergeField(String fieldName, boolean isAfter, boolean isDeleteField) throws Exception {
        if (fieldName == null) {
            throw new NullPointerException("fieldName");
        }
        FieldMergeField fieldMergeField = this.zzWIo().zzXeM() ? zzXf9.zzX6s(this.zzX32, fieldName) : zzXf9.zzWsU(this.zzWIo(), fieldName);
        if (fieldMergeField == null) {
            return false;
        }
        return this.zzWBj(fieldMergeField, isAfter, isDeleteField);
    }

    public void moveToField(Field field, boolean isAfter) throws Exception {
        this.zzWBj(field, isAfter, false);
    }

    private boolean zzWBj(Field field, boolean bl, boolean bl2) throws Exception {
        Node node;
        zz7b zz7b2 = field.getFormat().zzZwM();
        Inline inline = zz7b2.getSourceNode();
        if (bl2) {
            node = field.remove();
            if (node == null) {
                return false;
            }
        } else if (bl) {
            node = field.getEnd().getNextSibling();
            if (node == null) {
                node = field.getEnd().getParentParagraph();
            }
        } else {
            node = field.getStart();
        }
        this.moveTo(node);
        if (inline != null) {
            this.zzWBj(inline.zzZGF(), true);
        }
        return true;
    }

    public boolean moveToBookmark(String bookmarkName) throws Exception {
        return this.moveToBookmark(bookmarkName, true, true);
    }

    public boolean moveToBookmark(String bookmarkName, boolean isStart, boolean isAfter) throws Exception {
        if (bookmarkName == null) {
            throw new NullPointerException("bookmarkName");
        }
        Node node = isStart ? zzYnh.zzWBj(this.zzX32, bookmarkName) : zzYnh.zzYxS(this.zzX32, bookmarkName);
        if (node == null) {
            return false;
        }
        if (node.zzWng() == 6) {
            this.zzWBj((Paragraph)node.zziP(), isAfter ? node.getNextSibling() : node);
        } else {
            Paragraph paragraph = zzXbZ.zzXAU(node);
            if (paragraph == null) {
                return false;
            }
            Paragraph paragraph2 = paragraph;
            this.zzWBj(paragraph2, paragraph2.getFirstChild());
        }
        return true;
    }

    public void moveToParagraph(int paragraphIndex, int characterIndex) {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzWBj(documentBuilder.getCurrentStory(), paragraphIndex, characterIndex);
    }

    public void moveToCell(int tableIndex, int rowIndex, int columnIndex, int characterIndex) {
        Row row = this.zzZ3W(tableIndex, rowIndex);
        Cell cell = (Cell)row.getChild(7, columnIndex, false);
        if (cell == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: columnIndex");
        }
        cell.ensureMinimum();
        this.zzWBj(cell, characterIndex);
    }

    private void zzWBj(Paragraph paragraph, Node node) {
        if (node != null) {
            this.moveTo(node);
            return;
        }
        this.moveTo(paragraph);
    }

    public void moveTo(Node node) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        if (node.getDocument() != this.getDocument()) {
            throw new IllegalArgumentException("The node belongs to a different document.");
        }
        if (node.getParentNode() == null) {
            throw new IllegalArgumentException("Parent cannot be null.");
        }
        if (node.getNodeType() == 8 || node.zzWng() == 6) {
            this.zz0q(node);
        } else {
            Node node2 = node;
            if (zzXbZ.zztk(node2.getNodeType())) {
                Paragraph paragraph = zzXbZ.zzXAU(node);
                if (paragraph == null) {
                    throw new IllegalStateException("There is no paragraph next to the specified node.");
                }
                this.zz0q(paragraph.hasChildNodes() ? paragraph.getFirstChild() : paragraph);
            } else if (node.isComposite() && node.zzWng() == 3) {
                Node node3 = ((CompositeNode)node).getChild(8, 0, true);
                if (node3 == null) {
                    throw new IllegalStateException("The block level node doesn't contain paragraph.");
                }
                this.zz0q(node3);
            } else {
                throw new IllegalStateException("The node must be a block or an inline.");
            }
        }
        this.zzwe = 0;
        if (this.isAtEndOfParagraph()) {
            this.zzYdT();
            return;
        }
        if (!this.zz1Y()) {
            this.zzYdT();
        }
    }

    private boolean zz1Y() {
        Node node = this.zzWIo();
        if (!(node instanceof Inline)) {
            while (node != null && !(node instanceof Inline)) {
                node = node.getPreviousSibling();
            }
        }
        if (node == null) {
            for (node = this.zzWIo(); node != null && !(node instanceof Inline); node = node.getNextSibling()) {
            }
        }
        if (node != null) {
            Inline inline = (Inline)node;
            this.zzWBj(inline.zzZGF(), true);
            return true;
        }
        return false;
    }

    private void zzYdT() {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzWBj(documentBuilder.getCurrentParagraph().zzWZU(), true);
    }

    public Row deleteRow(int tableIndex, int rowIndex) {
        Row row = this.zzZ3W(tableIndex, rowIndex);
        Table table = row.getParentTable();
        if (this.zzY1x() != null) {
            throw new IllegalStateException("Cannot delete a table row while building a table.");
        }
        if (this.zzWIo().zzYzJ(row)) {
            boolean bl = row == table.getLastRow();
            if (!bl) {
                this.moveToCell(tableIndex, rowIndex + 1, 0, 0);
            } else {
                Paragraph paragraph = (Paragraph)table.zzCt();
                int n = 0;
                Paragraph paragraph2 = paragraph;
                DocumentBuilder documentBuilder = this;
                documentBuilder.zzWBj((CompositeNode)paragraph2, n);
            }
        }
        row.remove();
        if (table.getFirstRow() == null) {
            table.remove();
        }
        return row;
    }

    public void write(String text) {
        this.zzXcX(text, false);
    }

    public void writeln(String text) {
        this.zzXcX(text, true);
    }

    public void writeln() {
        this.insertParagraph();
    }

    public Paragraph insertParagraph() {
        this.zzYwb();
        Paragraph paragraph = this.getCurrentParagraph();
        zzZ6R zzZ6R2 = new zzZ6R(this.getDocument());
        try {
            Paragraph paragraph2 = new Paragraph(this.zzX32, this.zzYZ9(), this.zzXY2());
            this.getCurrentParagraph().getParentNode().insertAfter(paragraph2, this.getCurrentParagraph());
            if (this.isAtEndOfParagraph()) {
                this.moveTo(paragraph2);
            } else {
                paragraph2.zzYxS(this.zzWIo(), null, paragraph2.getLastChild());
            }
        }
        finally {
            zzZ6R2.dispose();
        }
        if (this.getDocument().zzYO3()) {
            zzXbZ.zzZON((zzPr)paragraph, this.getDocument().zzYgK());
        }
        return this.getCurrentParagraph();
    }

    final Paragraph zzMd() {
        zz45 zz452;
        Run run;
        Run run2;
        Cloneable cloneable;
        this.zzYwb();
        Node node = this.zzWIo();
        Paragraph paragraph = this.getCurrentParagraph();
        if (this.isAtEndOfParagraph()) {
            cloneable = paragraph;
            run2 = cloneable.zzW6X(false);
        } else {
            run2 = run = (Run)node.zzYtP(21);
        }
        if (run2 == null && zzZP5.zzZnb(node, paragraph.zzWYW())) {
            run = paragraph.zzWYW();
        }
        if (run != null) {
            cloneable = run.zzZGF();
            zz452 = (zz45)((zzZJo)cloneable).zzWlR();
        } else {
            cloneable = paragraph.zzWZU();
            zz452 = (zz45)((zzZJo)cloneable).zzWlR();
        }
        zz45 zz453 = zz452;
        Paragraph paragraph2 = new Paragraph(this.zzX32, this.zzYZ9(), zz453);
        paragraph.getParentNode().insertBefore(paragraph2, paragraph);
        zzZ6R zzZ6R2 = new zzZ6R(this.zzX32);
        try {
            Node node2 = this.isAtEndOfParagraph() ? null : node;
            paragraph2.zzYxS(paragraph.getFirstChild(), node2, paragraph2.getLastChild());
        }
        finally {
            zzZ6R2.dispose();
        }
        return paragraph2;
    }

    public void insertStyleSeparator() {
        zzZUE.zzX6s(this);
    }

    public void insertBreak(int breakType) {
        this.zzYi2(breakType, true);
    }

    final void zzYi2(int n, boolean bl) {
        block11: while (true) {
            switch (n) {
                case 0: {
                    this.insertParagraph();
                    return;
                }
                case 1: {
                    if (!this.zzWtV(bl)) {
                        return;
                    }
                    boolean bl2 = this.isAtStartOfParagraph() && !this.isAtEndOfParagraph();
                    this.zzEj(ControlChar.PAGE_BREAK);
                    CompatibilityOptions compatibilityOptions = this.getDocument().getCompatibilityOptions();
                    if (bl2 && (!compatibilityOptions.getSplitPgBreakAndParaMark() || compatibilityOptions.zzxA())) {
                        n = 0;
                        continue block11;
                    }
                    return;
                }
                case 2: {
                    if (this.zzWtV(bl)) {
                        this.zzEj(ControlChar.COLUMN_BREAK);
                    }
                    return;
                }
                case 4: {
                    if (this.zzWtV(bl)) {
                        this.zzfc(1);
                    }
                    return;
                }
                case 5: {
                    if (this.zzWtV(bl)) {
                        this.zzfc(2);
                    }
                    return;
                }
                case 3: {
                    if (this.zzWtV(bl)) {
                        this.zzfc(0);
                    }
                    return;
                }
                case 6: {
                    if (this.zzWtV(bl)) {
                        this.zzfc(3);
                    }
                    return;
                }
                case 7: {
                    if (this.zzWtV(bl)) {
                        this.zzfc(4);
                    }
                    return;
                }
                case 8: {
                    this.zzEj(ControlChar.LINE_BREAK);
                    return;
                }
            }
            break;
        }
        if (bl) {
            throw new IllegalStateException("Unknown break type.");
        }
    }

    public Field insertTableOfContents(String switches) {
        if (!zzYNb.zzY5B(switches)) {
            throw new IllegalArgumentException("switches is required.");
        }
        return this.insertField(zzZWZ.zzYxS("TOC {0}", switches), "");
    }

    public Field insertField(int fieldType, boolean updateField) throws Exception {
        this.zzYwb();
        return zzXbZ.zzWBj(fieldType, updateField, this.zzXY2(), this.zzWIo(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertField(String fieldCode) throws Exception {
        this.zzYwb();
        return zzXbZ.zzWBj(fieldCode, this.zzXY2(), this.zzWIo(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertField(String fieldCode, String fieldValue) {
        this.zzYwb();
        return zzXbZ.zzWBj(fieldCode, fieldValue, this.zzXY2(), this.zzWIo(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertHyperlink(String displayText, String urlOrBookmark, boolean isBookmark) {
        zzZP5.zzYxS((Object)displayText, "displayText");
        zzZP5.zzYxS((Object)urlOrBookmark, "hrefOrBookmark");
        zzX77 zzX772 = this.zzYxS(urlOrBookmark, isBookmark, "", "");
        this.write(displayText);
        DocumentBuilder documentBuilder = this;
        zzX772.zzYxS(documentBuilder.zzX8N(88, true));
        return zzXbZ.zzWBj(zzX772.getStart(), zzX772.getSeparator(), zzX772.getEnd());
    }

    public FormField insertTextInput(String name, int type, String format, String fieldValue, int maxLength) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (format == null) {
            throw new NullPointerException("format");
        }
        if (fieldValue == null) {
            throw new NullPointerException("fieldValue");
        }
        if (maxLength < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: maxLength");
        }
        this.zzVOA(70);
        if (zzYNb.zzY5B(name)) {
            this.startBookmark(name);
        }
        this.zznB(" FORMTEXT ");
        FieldSeparator fieldSeparator = this.zzVXo(70);
        String string = zzYNb.zzY5B(fieldValue) ? fieldValue : FormField.zzZEG;
        Run run = new Run(this.zzX32, string, this.zzXY2());
        this.insertNode(run);
        Node node = this.zzX8N(70, true);
        if (zzYNb.zzY5B(name)) {
            node = this.endBookmark(name);
        }
        FormField formField = this.zzX3R(fieldSeparator);
        formField.setName(name);
        formField.setTextInputType(type);
        formField.setTextInputFormat(format);
        formField.setResult(fieldValue);
        formField.setMaxLength(maxLength);
        this.zzWBj((Paragraph)node.zziP(), node.getNextSibling());
        return formField;
    }

    public FormField insertCheckBox(String name, boolean checkedValue, int size) throws Exception {
        boolean bl = checkedValue;
        return this.insertCheckBox(name, bl, bl, size);
    }

    public FormField insertCheckBox(String name, boolean defaultValue, boolean checkedValue, int size) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (size < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: size");
        }
        this.zzVOA(71);
        if (zzYNb.zzY5B(name)) {
            this.startBookmark(name);
        }
        this.zznB(" FORMCHECKBOX ");
        FieldEnd fieldEnd = this.zzX8N(71, false);
        if (zzYNb.zzY5B(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzX3R(fieldEnd);
        formField.setName(name);
        formField.setDefault(defaultValue);
        formField.setChecked(checkedValue);
        if (size != 0) {
            formField.isCheckBoxExactSize(true);
            formField.setCheckBoxSize(size);
        } else {
            formField.isCheckBoxExactSize(false);
            formField.setCheckBoxSize(10.0);
        }
        return formField;
    }

    public FormField insertComboBox(String name, String[] items, int selectedIndex) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (items == null) {
            throw new NullPointerException("items");
        }
        if (items.length > 25) {
            throw new IllegalArgumentException("items");
        }
        if (selectedIndex < 0 || selectedIndex >= items.length) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: selectedIndex");
        }
        this.zzVOA(83);
        if (zzYNb.zzY5B(name)) {
            this.startBookmark(name);
        }
        this.zznB(" FORMDROPDOWN ");
        FieldEnd fieldEnd = this.zzX8N(83, false);
        if (zzYNb.zzY5B(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzX3R(fieldEnd);
        formField.setName(name);
        formField.setDropDownSelectedIndex(selectedIndex);
        for (int i = 0; i < items.length; ++i) {
            formField.getDropDownItems().add(items[i]);
        }
        return formField;
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText) {
        return this.insertFootnote(footnoteType, footnoteText, null);
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText, String referenceMark) {
        Footnote footnote = new Footnote(this.zzX32, footnoteType, !zzYNb.zzY5B(referenceMark), referenceMark, this.zzXY2());
        Style style = this.getDocument().getStyles().zzYrS(zzXbZ.zzYMe(footnoteType));
        footnote.zzZGF().set(50, style.zzZOZ());
        this.insertNode(footnote);
        Paragraph paragraph = new Paragraph(this.zzX32);
        Style style2 = this.getDocument().getStyles().zzYrS(zzXbZ.zzWXX(footnoteType));
        paragraph.zzZ5U().set(1000, style2.zzZOZ());
        footnote.getParagraphs().add(paragraph);
        Inline inline = footnote.isAuto() ? new SpecialChar(this.zzX32, '\u0002', new zz45()) : new Run(this.zzX32, footnote.getReferenceMark(), new zz45());
        inline.zzZGF().set(50, style.zzZOZ());
        paragraph.appendChild(inline);
        if (zzYNb.zzY5B(footnoteText)) {
            Node node = this.zzWIo();
            this.moveTo(paragraph);
            this.write(" ");
            this.write(footnoteText);
            this.zz0q(node);
        }
        return footnote;
    }

    public Shape insertImage(BufferedImage image) throws Exception {
        return this.insertImage(image, -1.0, -1.0);
    }

    public Shape insertImage(String fileName) throws Exception {
        return this.insertImage(fileName, -1.0, -1.0);
    }

    final Shape zzZI4(zzXrr zzXrr2) throws Exception {
        return this.zzWBj(zzXrr2, -1.0, -1.0);
    }

    public Shape insertImage(InputStream stream) throws Exception {
        return this.zzZI4(zzXrr.zzYxS(stream));
    }

    public Shape insertImage(byte[] imageBytes) throws Exception {
        return this.insertImage(imageBytes, -1.0, -1.0);
    }

    public Shape insertImage(BufferedImage image, double width, double height) throws Exception {
        return this.insertImage(image, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(String fileName, double width, double height) throws Exception {
        return this.insertImage(fileName, 2, 0.0, 2, 0.0, width, height, 0);
    }

    private Shape zzWBj(zzXrr zzXrr2, double d, double d2) throws Exception {
        return this.zzWBj(zzXrr2, 2, 0.0, 2, 0.0, d, d2, 0);
    }

    public Shape insertImage(InputStream stream, double width, double height) throws Exception {
        return this.zzWBj(zzXrr.zzYxS(stream), width, height);
    }

    public Shape insertImage(byte[] imageBytes, double width, double height) throws Exception {
        return this.insertImage(imageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(BufferedImage image, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        if (image == null) {
            throw new NullPointerException("image");
        }
        try (zzXLE zzXLE2 = new zzXLE();){
            zzXQZ.zzWBj(image, zzXLE2);
            Shape shape = this.zzWBj(zzXLE2, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
    }

    public Shape insertImage(String fileName, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        Object object;
        zzZP5.zzYxS(fileName, "fileName");
        if (this.getDocument().getResourceLoadingCallback() != null) {
            object = new ResourceLoadingArgs("", fileName, 0);
            switch (this.getDocument().getResourceLoadingCallback().resourceLoading((ResourceLoadingArgs)object)) {
                case 0: {
                    break;
                }
                case 1: {
                    return null;
                }
                case 2: {
                    return this.insertImage(((ResourceLoadingArgs)object).getData(), horzPos, left, vertPos, top, width, height, wrapType);
                }
                default: {
                    return null;
                }
            }
        }
        object = zzZRe.zzYj9(fileName);
        try {
            Shape shape = this.zzWBj((zzXrr)object, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
        finally {
            if (object != null) {
                ((zzXrr)object).close();
            }
        }
    }

    private Shape zzWBj(zzXrr zzXrr2, int n, double d, int n2, double d2, double d3, double d4, int n3) throws Exception {
        if (zzXrr2 == null) {
            throw new NullPointerException("stream");
        }
        byte[] byArray = zzZP5.zzW3X(zzXrr2);
        return this.insertImage(byArray, n, d, n2, d2, d3, d4, n3);
    }

    public Shape insertImage(InputStream stream, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return this.zzWBj(zzXrr.zzYxS(stream), horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertImage(byte[] imageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return this.zzWBj(imageBytes, horzPos, left, vertPos, top, width, height, wrapType, false);
    }

    final Shape zzWBj(byte[] object, int n, double d, int n2, double d2, double d3, double d4, int n3, boolean bl) throws Exception {
        Object object2;
        Object object3;
        Shape shape;
        Object object4;
        if (object == null) {
            throw new NullPointerException("imageBytes");
        }
        boolean bl2 = false;
        if (zzZaD.zzWdg(object)) {
            object4 = new zzXQZ((byte[])object);
            bl2 = true;
            ((zzFv)object4).dispose();
        }
        object4 = null;
        boolean bl3 = this.zzX32.getCompatibilityOptions().getMswVersion() > 12 || this.zzX32.getCompatibilityOptions().getMswVersion() == 0;
        if (bl3) {
            shape = new Shape((DocumentBase)this.zzX32, 0);
            object3 = new zzTV();
            ((zzXy1)object3).zzWBj(zzWs9.zzYYe("rect"));
            ((zzTV)object3).zzWBj(new zzYGp());
            ((zzTV)object3).zzXyj().zzXS8().zzZON(this.zzX32);
            object2 = new zzYKw();
            ((zzXi5)object2).zzYxS(new zzWw1(this.zzX32.zzZvK(), ""));
            ((zzXi5)object2).zzWBj(new zzYeZ());
            ((zzZKw)object3).zzWBj((zzXi5)object2);
            shape.zzZ5W(75);
            shape.zzW3X((zzZKw)object3);
        } else {
            shape = new Shape((DocumentBase)this.zzX32, 75);
        }
        if (zzZaD.zzXbF(object)) {
            int n4 = bl3 ? 6 : 2;
            object2 = shape.getImageData().zzWBj((byte[])object, new zzZt0(this.getPageSetup().getPageWidth(), this.getPageSetup().getPageHeight()), new zzZt0(d3, d4), n4);
            if (bl3) {
                ImageSize imageSize = new ImageSize(zzZaD.zzVRd((byte[])object2));
                this.zzWBj((zzTV)shape.zzXJ8(), (byte[])object, imageSize);
            }
            object = object2;
        }
        if (bl3 && bl2) {
            ((zzTV)shape.zzXJ8()).zzXyj().zzXS8().zzWmV((byte[])object);
            object3 = zzZaD.zzAH(object);
            object4 = new zzZt0(((zzWkA)object3).getWidthPoints(), ((zzWkA)object3).getHeightPoints());
        } else {
            shape.getImageData().setImageBytes((byte[])object);
        }
        shape.zzWBj(this.zzXY2());
        shape.setRelativeHorizontalPosition(n);
        shape.setLeft(d);
        shape.setRelativeVerticalPosition(n2);
        shape.setTop(d2);
        shape.setWrapType(n3);
        shape.setAspectRatioLocked(true);
        this.insertNode(shape);
        double d5 = 0.0;
        if (!bl && bl3 && zzZaD.zzYrk(object)) {
            d5 = DocumentBuilder.zzWBj(shape, object);
        }
        shape.zzWBj(d3, d4, (zzZt0)object4, d5);
        if (d5 > 0.0) {
            shape.setRotation(d5);
        }
        return shape;
    }

    private static double zzWBj(Shape shape, byte[] byArray) throws Exception {
        int n = zzZaD.zzW8F(byArray);
        if (n == 1) {
            return 0.0;
        }
        int n2 = zzXbZ.zzWiw(n);
        if (n2 != 0) {
            shape.setFlipOrientation(n2);
        }
        double d = zzXbZ.zzXSg(n);
        return d;
    }

    private void zzWBj(zzTV zzTV2, byte[] byArray, ImageSize imageSize) throws Exception {
        byte[] byArray2;
        Object object;
        zzTV2.zzXyj().zzXS8().getExtensions();
        try (zzXLE zzXLE2 = new zzXLE(byArray);){
            object = zzXbZ.zzWBj(zzXLE2, this.zzX32);
            ((zzY6I)object).zzZv5(imageSize.getWidthPoints(), imageSize.getHeightPoints());
            ((zzY6I)object).zzYsH();
            byArray2 = ((zzY6I)object).zzY1k(true);
        }
        zzTV2.zzXyj().zzXS8().setExtensions(new zzW6p<zzYWw>());
        object = zzYWw.zzWBj(byArray2, this.zzX32);
        zzTV2.zzXyj().zzXS8().getExtensions().zzYnw(((zzYWw)object).getUri(), (zzYWw)object);
    }

    private Shape zzWBj(zzXrr zzXrr2, String string, boolean bl, zzXrr zzXrr3) throws Exception {
        zzYph zzYph2 = zzYph.zzY5C(string);
        Shape shape = this.zzWBj(zzXrr3, bl, zzYph2, null);
        zzNz zzNz2 = zzVTc.zzWBj(zzXrr2, string, bl);
        return DocumentBuilder.zzWBj(null, false, shape, zzYph2.zzZ2m, zzNz2);
    }

    public Shape insertOleObject(InputStream stream, String progId, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzWBj(zzXrr.zzYxS(stream), progId, asIcon, zzXrr.zzYxS(presentation));
    }

    private Shape zzWBj(String string, boolean bl, boolean bl2, zzXrr zzXrr2) throws Exception {
        zzYph zzYph2 = zzYph.zzWm(zzYY5.zzYf0(string));
        return this.zzWBj(string, bl, bl2, zzXrr2, zzYph2);
    }

    public Shape insertOleObject(String fileName, boolean isLinked, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzWBj(fileName, isLinked, asIcon, zzXrr.zzYxS(presentation));
    }

    private Shape zzWBj(String string, String string2, boolean bl, boolean bl2, zzXrr zzXrr2) throws Exception {
        zzYph zzYph2 = zzYph.zzY5C(string2);
        return this.zzWBj(string, bl, bl2, zzXrr2, zzYph2);
    }

    public Shape insertOleObject(String fileName, String progId, boolean isLinked, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzWBj(fileName, progId, isLinked, asIcon, zzXrr.zzYxS(presentation));
    }

    public Shape insertOleObjectAsIcon(String fileName, boolean isLinked, String iconFile, String iconCaption) throws Exception {
        zzYph zzYph2 = zzYph.zzWm(zzYY5.zzYf0(fileName));
        return this.zzWBj(fileName, isLinked, iconFile, iconCaption, zzYph2);
    }

    public Shape insertOleObjectAsIcon(String fileName, String progId, boolean isLinked, String iconFile, String iconCaption) throws Exception {
        zzYph zzYph2 = zzYph.zzY5C(progId);
        return this.zzWBj(fileName, isLinked, iconFile, iconCaption, zzYph2);
    }

    private Shape zzWBj(zzXrr zzXrr2, String string, String string2, String string3) throws Exception {
        zzYph zzYph2 = zzYph.zzY5C(string);
        Shape shape = this.zzWBj(string2, string3, zzYph2);
        zzNz zzNz2 = zzVTc.zzWBj(zzXrr2, string, true);
        return DocumentBuilder.zzWBj(null, false, shape, zzYph2.zzZ2m, zzNz2);
    }

    public Shape insertOleObjectAsIcon(InputStream stream, String progId, String iconFile, String iconCaption) throws Exception {
        return this.zzWBj(zzXrr.zzYxS(stream), progId, iconFile, iconCaption);
    }

    final Shape zzWBj(zzZyA zzZyA2, zzXrr zzXrr2) throws Exception {
        Shape shape = this.zzCR(zzXrr2);
        shape.zzZ5W(201);
        shape.getOleFormat().zzYxS(zzZyA2.zzY0E());
        return shape;
    }

    public void insertHtml(String html) throws Exception {
        this.insertHtml(html, 0);
    }

    public void insertHtml(String html, boolean useBuilderFormatting) throws Exception {
        int n = useBuilderFormatting ? 1 : 0;
        this.insertHtml(html, n);
    }

    public void insertHtml(String html, int options) throws Exception {
        this.zzYwb();
        if (this.zzY9C()) {
            DocumentBuilder documentBuilder = new DocumentBuilder();
            documentBuilder.insertHtml(html);
            this.write(DocumentBuilder.zzYTz(documentBuilder.getDocument().toString(70)));
            return;
        }
        zzYcb zzYcb2 = zzXbZ.zzWBj(html, options, this);
        zzYcb2.zzXG8();
    }

    public Shape insertShape(int shapeType, double width, double height) throws Exception {
        this.zzYwb();
        return zzXbZ.zzWBj(this, shapeType, width, height, 0);
    }

    public Shape insertShape(int shapeType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        this.zzYwb();
        return zzXbZ.zzWBj(this, shapeType, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertChart(int chartType, double width, double height) throws Exception {
        return this.insertChart(chartType, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertChart(int chartType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        zzWAq zzWAq2 = new zzWAq();
        return zzWAq2.zzWBj(chartType, horzPos, left, vertPos, top, width, height, wrapType, this);
    }

    public Shape insertOnlineVideo(String videoUrl, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzZAE(this).zzWBj(videoUrl, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, videoEmbedCode, thumbnailImageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzZAE(this).zzWBj(videoUrl, videoEmbedCode, thumbnailImageBytes, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions) throws Exception {
        return this.insertSignatureLine(signatureLineOptions, 2, 0.0, 2, 0.0, 0);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions, int horzPos, double left, int vertPos, double top, int wrapType) throws Exception {
        if (signatureLineOptions == null) {
            throw new NullPointerException("signatureLineOptions");
        }
        Shape shape = new Shape((DocumentBase)this.zzX32, 75);
        shape.zzWBj(this.zzXY2());
        shape.zzWTB(true);
        shape.getSignatureLine().zzWBj(signatureLineOptions);
        shape.setRelativeHorizontalPosition(horzPos);
        shape.setLeft(left);
        shape.setRelativeVerticalPosition(vertPos);
        shape.setTop(top);
        shape.setWrapType(wrapType);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzXgr(ConvertUtil.pixelToPoint(imageSize.getWidthPixels(), 96.0), ConvertUtil.pixelToPoint(imageSize.getHeightPixels(), 96.0));
        return shape;
    }

    public Shape insertHorizontalRule() throws Exception {
        Shape shape = Shape.zzY9w(this.zzX32);
        this.insertNode(shape);
        return shape;
    }

    private boolean zzY9C() {
        boolean bl = false;
        if (this.zzWIo().getParentNode().getNodeType() == 28) {
            StructuredDocumentTag structuredDocumentTag = (StructuredDocumentTag)this.zzWIo().getParentNode();
            switch (structuredDocumentTag.getSdtType()) {
                case 5: 
                case 6: 
                case 12: {
                    bl = true;
                    break;
                }
                case 10: {
                    break;
                }
                case 4: 
                case 13: {
                    throw new IllegalStateException("Can not insert text into this StructuredDocumentTag.");
                }
            }
        }
        return bl;
    }

    private static String zzYTz(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\u000b' || c == '\n' || c == '\f' || c == '\r' || c == '\f') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public Cell insertCell() {
        this.zzYwb();
        if (this.zzY1x() == null) {
            this.startTable();
        }
        if (this.zzY1x().zztO() == 1) {
            this.zzY1x().zzWR4();
        }
        if (this.zzY1x().zztO() == 3) {
            this.zzY1x().zzYyW();
        }
        return this.zzY1x().zzZNY();
    }

    public Table startTable() {
        this.zzYiG.push(new zzPt(this));
        return this.zzY1x().startTable();
    }

    public Table endTable() {
        if (this.zzY1x() == null) {
            throw new IllegalStateException("Cannot end a table while not building a table.");
        }
        Table table = this.zzY1x().endTable();
        this.zzYiG.pop();
        return table;
    }

    public Row endRow() {
        if (this.zzY1x() == null) {
            throw new IllegalStateException("Cannot end a row while not building a table.");
        }
        Row row = this.zzY1x().endRow();
        if (this.zzYT3 != null && this.zzYT3.getHidden()) {
            row.zzWx3().setHidden(true);
        }
        return row;
    }

    public BookmarkStart startBookmark(String bookmarkName) {
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzX32, bookmarkName, 0);
        this.insertNode(bookmarkStart);
        return bookmarkStart;
    }

    public BookmarkEnd endBookmark(String bookmarkName) {
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzX32, bookmarkName);
        this.insertNode(bookmarkEnd);
        return bookmarkEnd;
    }

    public BookmarkStart startColumnBookmark(String bookmarkName) {
        Cell cell = this.zzW0U();
        if (cell == null) {
            throw new IllegalStateException("A column bookmark can only be started in a table cell.");
        }
        Cell cell2 = cell.getParentRow().getFirstCell();
        cell2.ensureMinimum();
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzX32, bookmarkName);
        cell2.getFirstParagraph().insertAfter(bookmarkStart, null);
        int n = cell.zzY2U();
        bookmarkStart.zzXAI(n);
        return bookmarkStart;
    }

    public BookmarkEnd endColumnBookmark(String bookmarkName) {
        Cell cell = this.zzW0U();
        if (cell == null) {
            throw new IllegalStateException("A column bookmark can only be ended in a table cell.");
        }
        Cell cell2 = cell;
        Bookmark bookmark = cell2.getParentRow().getParentTable().getRange().getBookmarks().get(bookmarkName);
        if (bookmark == null) {
            throw new IllegalStateException("The corresponding bookmark start must be in the same table.");
        }
        int n = cell.zzY2U();
        if (bookmark.getBookmarkStart().getFirstColumn() > n) {
            throw new IllegalStateException("The end column index must be greater than or equal to the start column index.");
        }
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzX32, bookmarkName);
        cell2 = cell;
        cell2.getParentRow().getParentTable().insertAfter(bookmarkEnd, cell.getParentRow());
        bookmark.getBookmarkStart().zzYMJ(n);
        return bookmarkEnd;
    }

    public EditableRangeStart startEditableRange() {
        EditableRangeStart editableRangeStart = new EditableRangeStart(this.zzX32);
        this.zzX11 = editableRangeStart.getId();
        this.insertNode(editableRangeStart);
        return editableRangeStart;
    }

    public EditableRangeEnd endEditableRange() {
        if (this.zzX11 == -1) {
            throw new IllegalStateException("EndEditableRange can not be called before StartEditableRange.");
        }
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzX32, this.zzX11);
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public EditableRangeEnd endEditableRange(EditableRangeStart start) {
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzX32, start.getId());
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public Node insertDocument(Document srcDoc, int importFormatMode) {
        return this.insertDocument(srcDoc, importFormatMode, new ImportFormatOptions());
    }

    public Node insertDocument(Document srcDoc, int importFormatMode, ImportFormatOptions importFormatOptions) {
        zzZP5.zzYxS((Object)importFormatOptions, "ImportFormatOptions");
        this.zzYwb();
        return zzZE4.zzWBj(this, srcDoc, importFormatMode, importFormatOptions);
    }

    public Document getDocument() {
        return this.zzX32;
    }

    public void setDocument(Document value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (value == this.zzX32) {
            return;
        }
        this.zzX32 = value;
        this.zz0q(null);
        this.zz5t = new zz45();
        this.zzXEh = null;
        this.zzYFv = null;
        this.zzYT3 = null;
        this.zzYiG = new zz65();
        this.moveToDocumentStart();
    }

    public Font getFont() {
        if (this.zzYT3 == null) {
            DocumentBuilder documentBuilder = this;
            this.zzYT3 = new Font(documentBuilder, documentBuilder.getDocument());
        }
        return this.zzYT3;
    }

    public boolean getBold() {
        return this.getFont().getBold();
    }

    public void setBold(boolean value) {
        this.getFont().setBold(value);
    }

    public boolean getItalic() {
        return this.getFont().getItalic();
    }

    public void setItalic(boolean value) {
        this.getFont().setItalic(value);
    }

    public int getUnderline() {
        return this.getFont().getUnderline();
    }

    public void setUnderline(int value) {
        this.getFont().setUnderline(value);
    }

    public ParagraphFormat getParagraphFormat() {
        return this.getCurrentParagraph().getParagraphFormat();
    }

    public ListFormat getListFormat() {
        return this.getCurrentParagraph().getListFormat();
    }

    public PageSetup getPageSetup() {
        return this.getCurrentSection().getPageSetup();
    }

    public RowFormat getRowFormat() {
        if (this.zzYSw == null) {
            this.zzYSw = new RowFormat(this);
        }
        return this.zzYSw;
    }

    public CellFormat getCellFormat() {
        if (this.zzWHA == null) {
            this.zzWHA = new CellFormat(this);
        }
        return this.zzWHA;
    }

    final void zzXen(Node node) {
        this.getCurrentParagraph().getParentNode().insertBefore(node, this.getCurrentParagraph());
    }

    public void pushFont() {
        zz45 zz452 = this.getCurrentParagraph().zzWZU();
        this.zzY09().push(new zzWBj(this.zzXY2(), (zz45)zz452.zzWlR()));
    }

    public void popFont() {
        zz65<zzWBj> zz652 = this.zzY09();
        if (zz652.size() > 0) {
            zzWBj zzWBj2 = (zzWBj)this.zzY09().pop();
            this.zzWBj(zzWBj2.zzZGF(), false);
            this.getCurrentParagraph().zzYvR(zzWBj2.zzM8());
        }
    }

    final void zzY1V() {
        this.zzYz9().push(this.zzXY2());
    }

    final void zzXP6() {
        zz65<zz45> zz652 = this.zzYz9();
        if (zz652.size() > 0) {
            DocumentBuilder documentBuilder = this;
            documentBuilder.zzWBj((zz45)documentBuilder.zzYz9().pop(), false);
        }
    }

    final void zzZgd() {
        this.zzWe8().push(this.zzYZ9());
    }

    final void zzWy3() {
        zz65<zzWqZ> zz652 = this.zzWe8();
        if (zz652.size() > 0) {
            this.getCurrentParagraph().zzWBj((zzWqZ)this.zzWe8().pop());
        }
    }

    final zzX77 zzYxS(String string, boolean bl, String string2, String string3) {
        FieldStart fieldStart = this.zzVOA(88);
        zzaE zzaE2 = new zzaE();
        zzaE2.setTarget(string2);
        zzaE2.setScreenTip(string3);
        if (bl) {
            zzaE2.setSubAddress(string);
        } else {
            zzaE2.setAddress(zzXpm.zzZHS(string));
            zzaE2.setSubAddress(zzXpm.zzWuE(string));
        }
        this.zznB(zzaE2.zzXmi());
        FieldSeparator fieldSeparator = this.zzVXo(88);
        return new zzX77(fieldStart, fieldSeparator, null);
    }

    final zzX77 zzZEp(String string, String string2, String string3) {
        boolean bl = zzXpm.zzWRN(string);
        String string4 = bl ? zzXpm.zzWuE(string) : string;
        return this.zzYxS(string4, bl, string2, string3);
    }

    final FieldEnd zzYe2() {
        return this.zzX8N(88, true);
    }

    final zz45 zzXY2() {
        zz45 zz452 = this.zz5t;
        return (zz45)zz452.zzWlR();
    }

    final zzWqZ zzYZ9() {
        zzWqZ zzWqZ2 = this.getCurrentParagraph().zzZ5U();
        return (zzWqZ)zzWqZ2.zzWlR();
    }

    final zzX9u zzVWO() {
        zzX9u zzX9u2 = this.zzWx3();
        return (zzX9u)zzX9u2.zzWlR();
    }

    final zzYOU zzXB6() {
        zzYOU zzYOU2 = this.zzYN5();
        return (zzYOU)zzYOU2.zzWlR();
    }

    public boolean isAtStartOfParagraph() {
        for (Node node = this.getCurrentParagraph().getFirstChild(); node != null && node != this.zzWIo(); node = node.getNextSibling()) {
            if (node.getNodeType() == 9 || node.getNodeType() == 10) {
                continue;
            }
            return false;
        }
        return true;
    }

    public boolean isAtEndOfParagraph() {
        return this.zzWIo().getNodeType() == 8;
    }

    private void zzXcX(String string, boolean bl) {
        if (string == null) {
            throw new NullPointerException("text");
        }
        String string2 = zzSI.zzW7d(string);
        int n = 0;
        while (n <= string2.length()) {
            int n2;
            int n3 = string2.indexOf(13, n);
            if (n3 != -1) {
                n2 = n3 - n;
                if (n2 > 0) {
                    int n4 = n;
                    this.zzYLP(string2.substring(n4, n4 + n2));
                }
                switch (this.zzYXQ) {
                    case 0: {
                        this.insertParagraph();
                        break;
                    }
                    case 1: {
                        this.zzEj(ControlChar.PARAGRAPH_BREAK);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                n = n3 + 1;
                continue;
            }
            n2 = string2.length() - n;
            if (n2 > 0) {
                int n5 = n;
                this.zzYLP(string2.substring(n5, n5 + n2));
            }
            if (!bl) break;
            this.insertParagraph();
            return;
        }
    }

    public void insertNode(Node node) {
        this.zzYwb();
        if (this.zzY1x() != null && this.zzY1x().zztO() == 1) {
            this.endTable();
        }
        if (this.isAtEndOfParagraph()) {
            this.getCurrentParagraph().appendChild(node);
            return;
        }
        this.zzWIo().getParentNode().insertBefore(node, this.zzWIo());
    }

    final void zzY7v(int n) {
        this.zzWtV(true);
        this.zzfc(n);
    }

    private void zzfc(int n) {
        this.insertParagraph();
        zzZ6R zzZ6R2 = new zzZ6R(this.getDocument());
        try {
            zzZ73 zzZ732 = this.getCurrentSection().zzZFV();
            zzZ73 zzZ733 = (zzZ73)zzZ732.zzWlR();
            Section section = new Section(this.zzX32, zzZ733);
            section.getPageSetup().setSectionStart(n);
            section.appendChild(new Body(this.zzX32));
            this.zzX32.insertAfter(section, this.getCurrentSection());
            section.getBody().zzYxS(this.getCurrentParagraph(), null, section.getBody().getLastChild());
            return;
        }
        finally {
            zzZ6R2.dispose();
        }
    }

    final FieldStart zzVOA(int n) {
        this.zzYwb();
        return zzXbZ.zzWBj(n, this.zzXY2(), this.zzWIo(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    final Run zznB(String string) {
        return zzXbZ.zzYxS(string, this.zzXY2(), this.zzWIo(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    final FieldEnd zzX8N(int n, boolean bl) {
        return zzXbZ.zzYxS(n, bl, this.zzXY2(), this.zzWIo(), this.getCurrentParagraph(), null, true);
    }

    final FieldSeparator zzVXo(int n) {
        return zzXbZ.zzYxS(n, this.zzXY2(), this.zzWIo(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    private FormField zzX3R(Node node) {
        FormField formField = new FormField((DocumentBase)this.zzX32, new zzYgW(), this.zzXY2());
        CompositeNode compositeNode = node == null ? this.getCurrentParagraph() : node.getParentNode();
        compositeNode.insertBefore(formField, node);
        return formField;
    }

    private boolean zzWtV(boolean bl) {
        boolean bl2;
        boolean bl3 = this.getCurrentParagraph().getParentStory().getStoryType() != 1;
        boolean bl4 = bl2 = this.zzY1x() != null;
        if (bl) {
            if (bl3) {
                throw new IllegalStateException("Cannot insert the requested break outside of the main story.");
            }
            if (bl2) {
                throw new IllegalStateException("Cannot insert the requested break inside a table.");
            }
        }
        return bl || !bl3 && !bl2;
    }

    private Row zzZ3W(int n, int n2) {
        NodeCollection nodeCollection = this.getCurrentStory().getChildNodes(5, true);
        Table table = (Table)nodeCollection.get(n);
        if (table == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: tableIndex");
        }
        Row row = (Row)table.getChild(6, n2, false);
        if (row == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: rowIndex");
        }
        return row;
    }

    private void zzYLP(String string) {
        if (this.zzY81(string)) {
            zzWnH zzWnH2 = new zzWnH(string, this.getParagraphFormat().getBidi() ? 1 : 0, null);
            for (zzYKG zzYKG2 : zzWnH2.zzWAq(this.getParagraphFormat().getBidi())) {
                zz0q zz0q2 = zz0q.zzUr(zzYKG2.zzXIb());
                zz45 zz452 = this.zzXY2();
                zz452.zzZEp(265, zz0q2);
                if (zzYKG2.zzY2l()) {
                    zz452.setLocaleIdBi(1037);
                }
                Run run = new Run(this.zzX32, zzYKG2.getText(), zz452);
                this.insertNode(run);
            }
            return;
        }
        this.zzEj(string);
    }

    private boolean zzY81(String string) {
        boolean bl = this.getFont().getBidi();
        for (int i = 0; i < string.length(); ++i) {
            boolean bl2;
            char c = string.charAt(i);
            int n = zzjb.zzY7b(c);
            boolean bl3 = n == 0;
            boolean bl4 = bl2 = n == 1 || n == 2;
            if ((!bl || !bl3) && (bl || !bl2)) continue;
            return true;
        }
        return false;
    }

    final void zzWBj(zz45 zz452, boolean bl) {
        zz45 zz453;
        if (bl) {
            zz45 zz454 = zz452;
            zz453 = (zz45)zz454.zzWlR();
        } else {
            zz453 = zz452;
        }
        this.zz5t = zz453;
    }

    final void zzYTZ() {
        this.zz5t.clear();
    }

    final void zzXbK() {
        if (this.zzW0U() != null) {
            zzYOU zzYOU2;
            zzYOU zzYOU3 = zzYOU2 = this.zzW0U().zzYN5();
            this.zzVOI = (zzYOU)zzYOU3.zzWlR();
            zzYOU2.zzYxS(this.zzVOI);
        }
    }

    private Shape zzWBj(String string, boolean bl, boolean bl2, zzXrr zzXrr2, zzYph zzYph2) throws Exception {
        if (zzYph2 == null) {
            throw new NullPointerException("oleInfo");
        }
        Shape shape = this.zzWBj(zzXrr2, bl2, zzYph2, string);
        zzNz zzNz2 = zzVTc.zzWBj(string, bl, bl2, zzYph2);
        return DocumentBuilder.zzWBj(string, bl, shape, zzYph2.zzZ2m, zzNz2);
    }

    private Shape zzWBj(String string, boolean bl, String string2, String string3, zzYph zzYph2) throws Exception {
        if (zzYph2 == null) {
            throw new NullPointerException("oleInfo");
        }
        if (string3 == null) {
            string3 = zzYY5.zzYRq(string);
        }
        Shape shape = string2 != null ? this.zzW8F(string2, string3) : this.zzWBj(null, string3, zzYph2);
        zzNz zzNz2 = zzVTc.zzWBj(string, bl, true, zzYph2);
        return DocumentBuilder.zzWBj(string, bl, shape, zzYph2.zzZ2m, zzNz2);
    }

    private static Shape zzWBj(String string, boolean bl, Shape shape, String string2, zzNz zzNz2) {
        if (shape == null) {
            throw new NullPointerException("insertedOleImage");
        }
        shape.zzZ5W(-2);
        shape.getOleFormat().setProgId(string2);
        shape.getOleFormat().zzYxS(zzNz2);
        if (bl) {
            shape.getOleFormat().setSourceFullName(string);
        }
        return shape;
    }

    private Shape zzWBj(zzXrr zzXrr2, boolean bl, zzYph zzYph2, String string) throws Exception {
        if (zzYph2 == null) {
            throw new NullPointerException("oleInfo");
        }
        if (zzXrr2 != null) {
            return this.zzCR(zzXrr2);
        }
        if (!bl) {
            return this.zzZZ5(zzVTc.zzWc6().get("normal"));
        }
        String string2 = string != null ? zzYY5.zzYRq(string) : zzVTc.zzVSq(zzYph2.zzZaZ);
        return this.zzWBj(zzYph2, string2);
    }

    private Shape zzWBj(String string, String string2, zzYph zzYph2) throws Exception {
        if (zzYph2 == null) {
            throw new NullPointerException("oleInfo");
        }
        if (string2 == null) {
            string2 = zzVTc.zzVSq(zzYph2.zzZaZ);
        }
        if (string != null) {
            return this.zzW8F(string, string2);
        }
        return this.zzWBj(zzYph2, string2);
    }

    private Shape zzWBj(zzYph zzYph2, String string) throws Exception {
        if (zzYph2 == null) {
            throw new NullPointerException("oleInfo");
        }
        byte[] byArray = zzVTc.zzYNg(zzYph2.zzZaZ);
        zzYhL zzYhL2 = new zzYhL(byArray, null, string, this.getDocument().zzZSC());
        return this.zzZZ5(zzYhL2.zzXdB());
    }

    private Shape zzW8F(String string, String string2) throws Exception {
        zzYhL zzYhL2 = new zzYhL(string, string2, this.getDocument().zzZSC());
        return this.zzZZ5(zzYhL2.zzXdB());
    }

    private Shape zzCR(zzXrr zzXrr2) throws Exception {
        byte[] byArray = zzZP5.zzW3X(zzXrr2);
        return this.zzZZ5(byArray);
    }

    private Shape zzZZ5(byte[] byArray) throws Exception {
        if (byArray == null) {
            throw new NullPointerException("imageBytes");
        }
        Shape shape = new Shape((DocumentBase)this.zzX32, 1);
        shape.zzZ5W(75);
        shape.zzWBj(this.zzXY2());
        shape.getImageData().setImageBytes(byArray);
        shape.setRelativeHorizontalPosition(2);
        shape.setLeft(0.0);
        shape.setRelativeVerticalPosition(2);
        shape.setTop(0.0);
        shape.setWrapType(0);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzXgr(imageSize.getWidthPoints(), imageSize.getHeightPoints());
        return shape;
    }

    private void zzWBj(CompositeNode compositeNode, int n) {
        if (n >= 0) {
            this.zzYxS(compositeNode, n);
            return;
        }
        this.zzZON(compositeNode, n);
    }

    private void zzYxS(CompositeNode compositeNode, int n) {
        zzFn zzFn2 = zzFn.zzVSp(compositeNode);
        Node node = null;
        while (node != compositeNode) {
            zzFn2.zzWBj(null, true, true, true, false, true);
            node = zzFn2.getNode();
            if (zzFn2.zzZ38() && (!node.isComposite() || node.zzWng() != 6 || n != 0)) continue;
            int n2 = node.isComposite() ? ((CompositeNode)node).zzYvb().length() : node.getTextLength();
            int n3 = n;
            if (n3 != 0 && (n -= n2) >= 0) continue;
            this.zzWBj(null, node);
            this.zzwe = n3;
            return;
        }
        throw new IllegalStateException("The character index is too large.");
    }

    private void zzZON(CompositeNode compositeNode, int n) {
        zzFn zzFn2 = zzFn.zzWOD(compositeNode);
        while (zzFn2.getNode() != compositeNode || !zzFn2.zzZ38()) {
            int n2;
            Node node = zzFn2.getNode();
            int n3 = n2 = node.isComposite() ? ((CompositeNode)node).zzYvb().length() : node.getTextLength();
            if ((n += n2) >= 0) {
                this.zzWBj(null, node);
                this.zzwe = n;
                return;
            }
            while (zzFn2.zzWBj(null, false, true, true, false, true) && zzFn2.zzZ38() && zzFn2.getNode() != compositeNode) {
            }
        }
        throw new IllegalStateException("The character index is too small.");
    }

    private void zzYwb() {
        int n = this.zzwe;
        if (n == 0) {
            return;
        }
        this.zzwe = 0;
        Run run = zzZP5.zzWBj((Object)this.getCurrentNode(), Run.class);
        if (run != null) {
            run.zzWEO(n);
        }
    }

    private Run zzEj(String string) {
        Run run = new Run(this.zzX32, string, this.zzXY2());
        this.insertNode(run);
        return run;
    }

    final boolean zzXwC() {
        return !this.isAtEndOfParagraph() && this.getCurrentNode().getParentNode().getNodeType() == 17;
    }

    final int zzYUp() {
        return this.zzYXQ;
    }

    final void zzXQy(int n) {
        this.zzYXQ = n;
    }

    public Node getCurrentNode() {
        if (this.isAtEndOfParagraph()) {
            return null;
        }
        return this.zzWIo();
    }

    public Paragraph getCurrentParagraph() {
        if (this.isAtEndOfParagraph()) {
            return (Paragraph)this.zzWIo();
        }
        return (Paragraph)this.zzWIo().getAncestor(8);
    }

    public Story getCurrentStory() {
        return this.getCurrentParagraph().getParentStory();
    }

    public Section getCurrentSection() {
        return (Section)this.getCurrentStory().getParentNode();
    }

    private zzPt zzY1x() {
        zz65<zzPt> zz652 = this.zzYiG;
        if (zz652.size() > 0) {
            return (zzPt)this.zzYiG.peek();
        }
        return null;
    }

    private Cell zzW0U() {
        if (this.getCurrentParagraph() == null) {
            return null;
        }
        return this.getCurrentParagraph().zzWcr();
    }

    private zz65<zz45> zzYz9() {
        if (this.zzXEh == null) {
            this.zzXEh = new zz65();
        }
        return this.zzXEh;
    }

    private zz65<zzWqZ> zzWe8() {
        if (this.zzYFv == null) {
            this.zzYFv = new zz65();
        }
        return this.zzYFv;
    }

    private zz65<zzWBj> zzY09() {
        if (this.zzX50 == null) {
            this.zzX50 = new zz65();
        }
        return this.zzX50;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRunAttr(int fontAttr) {
        return this.zz5t.zzXte(fontAttr);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRunAttr(int fontAttr) {
        Object object = this.getFont().getStyle().zzX27(fontAttr, false);
        if (object != null) {
            return object;
        }
        return this.getParagraphFormat().getStyle().zzX27(fontAttr, true);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRunAttr(int fontAttr, Object value) {
        this.zz5t.zzZEp(fontAttr, value);
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzXsD()) {
            this.getCurrentParagraph().zzWZU().zzZEp(fontAttr, value);
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeRunAttr(int key) {
        this.zz5t.remove(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRunAttrs() {
        this.zz5t.clear();
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzXsD()) {
            this.getCurrentParagraph().zzWZU().clear();
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRowAttr(int key) {
        return this.zzWx3().zzXte(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchRowAttr(int key) {
        return this.zzWx3().zzX4H(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRowAttr(int key) {
        return this.zzWx3().zzYMg(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRowAttr(int key, Object value) {
        this.zzWx3().zzZEp(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRowAttrs() {
        this.zzWx3().clearRowAttrs();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void resetToDefaultAttrs() {
        this.zzWx3().clear();
        zzX9u.zzXzG().zzYxS(this.zzWx3());
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zzYN5().zzXte(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        return this.zzYN5().zzX4H(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        return this.zzYN5().zzYMg(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        Border border = zzZP5.zzWBj(value, Border.class);
        if (border != null) {
            CellFormat cellFormat = this.zzW0U() != null ? this.zzW0U().getCellFormat() : this.getCellFormat();
            border.zzWBj(cellFormat);
        }
        this.zzYN5().zzZEp(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zzYN5().clear();
    }

    private Node zzWIo() {
        Node node = this.zzXZx != null && this.zzXZx.getParentNode() == null ? this.zzWPQ : this.zzXZx;
        if (node != null && node.zzWng() == 2) {
            Paragraph paragraph = ((Story)node).getFirstParagraph();
            node = paragraph == null ? ((Section)node.getAncestor(2)).getBody().getFirstParagraph() : paragraph;
        }
        if (node == null) {
            node = this.getDocument().getFirstSection().getBody().getFirstParagraph();
        }
        return node;
    }

    private void zz0q(Node node) {
        this.zzXZx = node;
        if (this.zzXZx != null) {
            this.zzWPQ = this.zzXZx.getParentNode();
        }
    }

    private zzX9u zzWx3() {
        if (this.zzY1x() != null && this.zzY1x().zztO() == 1) {
            return this.zzWI0;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().getParentRow().zzWx3();
        }
        return this.zzWI0;
    }

    private zzYOU zzYN5() {
        if (this.zzY1x() != null && this.zzY1x().zztO() != 3) {
            return this.zzVOI;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().zzWcr().zzYN5();
        }
        return this.zzVOI;
    }

    static final class zzWBj {
        private zz45 zz5t;
        private zz45 zzXpK;

        public zzWBj(zz45 zz452, zz45 zz453) {
            this.zz5t = zz452;
            this.zzXpK = zz453;
        }

        public final zz45 zzZGF() {
            return this.zz5t;
        }

        public final zz45 zzM8() {
            return this.zzXpK;
        }
    }
}

