/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.NodeChangingArgs;
import com.aspose.words.NodeCollection;
import com.aspose.words.NodeList;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SmartTag;
import com.aspose.words.internal.zzZP5;
import com.aspose.words.zzVSu;
import com.aspose.words.zzXTV;
import com.aspose.words.zzXbZ;
import com.aspose.words.zzXcF;
import com.aspose.words.zzXkU;
import com.aspose.words.zzYID;
import com.aspose.words.zzZ6R;
import com.aspose.words.zzhX;
import java.util.Iterator;

public abstract class CompositeNode<T extends Node>
extends Node
implements zzXcF,
Iterable<T> {
    private Node zzaQ;
    private Node zzX5X;
    private Node zzav;

    protected CompositeNode() {
    }

    protected CompositeNode(DocumentBase doc) {
        super(doc);
    }

    protected void coreRemoveSelfOnly() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("This node is not attached to any document");
        }
        while (this.hasChildNodes()) {
            this.getParentNode().insertAfter(this.getLastChild(), this);
        }
        this.getParentNode().zzYxS((Node)this, true);
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    public boolean hasChildNodes() {
        return this.getLastChild() != null;
    }

    final boolean zzCu() {
        return this.zzZQy() != null;
    }

    final boolean zzW7() {
        return this.hasChildNodes() && this.getFirstChild() == this.getLastChild();
    }

    final boolean zzXIF() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node instanceof zzVSu) {
                return true;
            }
            CompositeNode compositeNode = zzZP5.zzWBj((Object)node, CompositeNode.class);
            if (compositeNode == null || !compositeNode.zzXIF()) continue;
            return true;
        }
        return false;
    }

    public NodeCollection getChildNodes() {
        return this.getChildNodes(0, false);
    }

    public Node getFirstChild() {
        return this.zzaQ;
    }

    public Node getLastChild() {
        return this.zzX5X;
    }

    final Node zzZQy() {
        return zzXbZ.zzXGB(this.getFirstChild(), false);
    }

    final Node zzXlu() {
        return zzXbZ.zzoC(this.getLastChild(), false);
    }

    final CompositeNode zzY7y() {
        return (CompositeNode)zzXbZ.zzXGB(this.getFirstChild(), true);
    }

    final CompositeNode zzZwE() {
        return (CompositeNode)zzXbZ.zzoC(this.getLastChild(), true);
    }

    final Node zzMH() {
        Node node;
        Node node2;
        for (node2 = this.getFirstChild(); node2 != null && zzXbZ.zztk((node = node2).getNodeType()); node2 = node2.getNextSibling()) {
        }
        return node2;
    }

    final Node zzWEJ() {
        Node node;
        Node node2;
        for (node2 = this.getLastChild(); node2 != null && zzXbZ.zztk((node = node2).getNodeType()); node2 = node2.getPreviousSibling()) {
        }
        return node2;
    }

    public int getCount() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            ++n;
        }
        return n;
    }

    @Override
    Node zzWBj(boolean bl, zzXkU zzXkU2) {
        CompositeNode compositeNode = (CompositeNode)super.zzWBj(bl, zzXkU2);
        ((CompositeNode)super.zzWBj(bl, zzXkU2)).zzX5X = null;
        compositeNode.zzaQ = null;
        if (bl) {
            for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                compositeNode.zzXMi(node.zzWBj(true, zzXkU2));
            }
        }
        return compositeNode;
    }

    @Override
    public String getText() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzZon(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    final void zzZon(StringBuilder stringBuilder) {
        this.zzZnb(stringBuilder);
        zzZP5.zzYxS(stringBuilder, this.zzYvb());
    }

    public NodeCollection getChildNodes(int nodeType, boolean isDeep) {
        return new NodeCollection(this, nodeType, isDeep);
    }

    final NodeCollection zzYxS(int[] nArray, boolean bl) {
        return new NodeCollection(this, nArray, true);
    }

    public Node getChild(int nodeType, int index, boolean isDeep) {
        if (index >= 0 && !isDeep) {
            Node node;
            int n = index + 1;
            boolean bl = zzXbZ.zzXCK(nodeType);
            Node node2 = node = bl ? this.zzZQy() : this.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == nodeType || nodeType == 0) {
                    --n;
                }
                if (n == 0) {
                    return node;
                }
                node = bl ? node.zzWBV() : node.getNextSibling();
            }
        } else {
            NodeCollection nodeCollection = this.getChildNodes(nodeType, isDeep);
            return nodeCollection.get(index);
        }
        return null;
    }

    public NodeList selectNodes(String xpath) {
        return zzXTV.zzZON(this, xpath);
    }

    public Node selectSingleNode(String xpath) {
        return zzXTV.zzZdS(this, xpath);
    }

    @Override
    public Iterator<T> iterator() {
        return new zzYID(this);
    }

    public Node appendChild(Node newChild) {
        return this.insertAfter(newChild, this.getLastChild());
    }

    public Node prependChild(Node newChild) {
        return this.insertBefore(newChild, this.getFirstChild());
    }

    public Node insertAfter(Node newChild, Node refChild) {
        return this.zzWBj(newChild, refChild, true);
    }

    public Node insertBefore(Node newChild, Node refChild) {
        return this.zzWBj(newChild, refChild, false);
    }

    public Node removeChild(Node oldChild) {
        return this.zzYxS(oldChild, false);
    }

    private Node zzYxS(Node node, boolean bl) {
        if (node == null) {
            throw new NullPointerException("oldChild");
        }
        if (node.getParentNode() != this) {
            throw new IllegalArgumentException("This node is not a parent of the oldChild node.");
        }
        DocumentBase documentBase = this.getDocument();
        NodeChangingArgs nodeChangingArgs = documentBase.zzWBj(node, (Node)this, null, 1);
        if (documentBase.zzYO3() && zzXbZ.zzZJ9(node)) {
            return node;
        }
        if (nodeChangingArgs != null) {
            documentBase.zzWBj(nodeChangingArgs);
        }
        if (!bl && zzXbZ.zzeM(node)) {
            zzXbZ.zzZEp(node, false);
        }
        Node node2 = this.zzXcX(node);
        if (nodeChangingArgs != null) {
            documentBase.zzYxS(nodeChangingArgs);
        }
        return node2;
    }

    public void removeAllChildren() {
        zzhX.zzWWx(this.getFirstChild(), null);
    }

    public void removeSmartTags() {
        for (SmartTag smartTag : this.getChildNodes(27, true)) {
            smartTag.coreRemoveSelfOnly();
        }
    }

    final Node zzXMi(Node node) {
        node.getParentNode();
        if (this.zzX5X == null) {
            node.zzZCD(null);
            node.zzYwV(null);
            this.zzaQ = node;
        } else {
            node.zzZCD(this.zzX5X);
            node.zzYwV(null);
            this.zzX5X.zzYwV(node);
        }
        this.zzX5X = node;
        node.zzWkR(this);
        return node;
    }

    final void zzWBj(Node node, Node node2, Node node3) {
        this.zzWBj(node, node2, node3, false);
    }

    final void zzWBj(Node node, Node node2, Node node3, boolean bl) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            if (!bl || this.zzX6s(node4)) {
                this.insertBefore(node4, node3);
            }
            node4 = node5;
        }
    }

    final void zzYxS(Node node, Node node2, Node node3) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            node3 = this.insertAfter(node4, node3);
            node4 = node5;
        }
    }

    public int indexOf(Node child) {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node == child) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    final int zzZON(Node node, boolean bl) {
        int n = 0;
        for (Node node2 = this.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            Node node3 = node2;
            if (zzXbZ.zztk(node3.getNodeType())) continue;
            if (zzXbZ.zzW3X(node, node2)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    final int getTextLength() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            n += node.getTextLength();
        }
        return n += this.zzYvb().length();
    }

    String zzYvb() {
        return "";
    }

    final String zzWjV() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzZnb(stringBuilder);
        return stringBuilder.toString();
    }

    private void zzZnb(StringBuilder stringBuilder) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            node.zzZon(stringBuilder);
        }
    }

    protected boolean acceptCore(DocumentVisitor visitor) throws Exception {
        switch (this.zzWBj(visitor)) {
            case 0: {
                break;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            default: {
                throw new IllegalStateException("Unknown visitor action.");
            }
        }
        if (!this.acceptChildren(visitor)) {
            return false;
        }
        return CompositeNode.visitorActionToBool(this.zzYxS(visitor));
    }

    abstract int zzWBj(DocumentVisitor var1) throws Exception;

    abstract int zzYxS(DocumentVisitor var1) throws Exception;

    protected boolean acceptChildren(DocumentVisitor visitor) throws Exception {
        Node node = this.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (!node.accept(visitor)) {
                return false;
            }
            node = node2;
        }
        return true;
    }

    abstract boolean zzX6s(Node var1);

    final Node zzWBj(Node node, Node node2, boolean bl) {
        Object object;
        if (node2 != null && node2.getParentNode() != this) {
            throw new IllegalArgumentException("The reference node is not a child of this node.");
        }
        if (node == null) {
            throw new IllegalArgumentException("Cannot insert a null node.");
        }
        if (node == this) {
            throw new IllegalArgumentException("Cannot add a node to self.");
        }
        if (this.zzYzJ(node)) {
            throw new IllegalArgumentException("The newChild is an ancestor of this node.");
        }
        if (node == node2) {
            throw new IllegalArgumentException("Cannot add a node before/after itself.");
        }
        DocumentBase documentBase = this.getDocument();
        DocumentBase documentBase2 = node.getDocument();
        if (documentBase2 != documentBase) {
            throw new IllegalArgumentException("The newChild was created from a different document than the one that created this node.");
        }
        if (node.getNodeType() != 37 && !this.zzX6s(node)) {
            throw new IllegalArgumentException("Cannot insert a node of this type at this location.");
        }
        CompositeNode compositeNode = node.getParentNode();
        Node node3 = node.getNextSibling();
        if (compositeNode != null) {
            object = new zzZ6R(documentBase);
            try {
                compositeNode.zzYxS(node, true);
            }
            finally {
                ((zzZ6R)object).dispose();
            }
        }
        if ((object = documentBase.zzWBj(node, null, (Node)this, 0)) != null) {
            documentBase.zzWBj((NodeChangingArgs)object);
        }
        if (this.zzX5X == null) {
            node.zzZCD(null);
            node.zzYwV(null);
            this.zzaQ = node;
            this.zzX5X = node;
        } else if (bl) {
            if (node2 != null) {
                this.zzYxS(node, node2);
            } else {
                this.zzZON(node, this.zzaQ);
            }
        } else if (node2 != null) {
            this.zzZON(node, node2);
        } else {
            this.zzYxS(node, this.zzX5X);
        }
        node.zzWkR(this);
        if (object != null) {
            documentBase.zzYxS((NodeChangingArgs)object);
        }
        if (documentBase.zzYO3()) {
            zzXbZ.zzWBj(node, compositeNode, node3);
        }
        return node;
    }

    private void zzYxS(Node node, Node node2) {
        Node node3 = node2.zzVS4();
        node.zzZCD(node2);
        node.zzYwV(node3);
        node2.zzYwV(node);
        if (node3 == null) {
            this.zzX5X = node;
            return;
        }
        node3.zzZCD(node);
    }

    private void zzZON(Node node, Node node2) {
        Node node3 = node2.zzWlh();
        node.zzZCD(node3);
        node.zzYwV(node2);
        node2.zzZCD(node);
        if (node3 == null) {
            this.zzaQ = node;
            return;
        }
        node3.zzYwV(node);
    }

    private Node zzXcX(Node node) {
        if (node == this.zzaQ) {
            if (this.zzaQ == this.zzX5X) {
                this.zzaQ = null;
                this.zzX5X = null;
            } else {
                this.zzaQ = node.zzVS4();
                this.zzaQ.zzZCD(null);
            }
        } else {
            Node node2 = node.zzWlh();
            Node node3 = node.zzVS4();
            node2.zzYwV(node3);
            if (node3 == null) {
                this.zzX5X = node2;
            } else {
                node3.zzZCD(node2);
            }
        }
        node.zzYwV(null);
        node.zzZCD(null);
        node.zzWkR(null);
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Node curNode) {
        Node node = curNode;
        this.zzav = curNode == this ? this.getFirstChild() : curNode.getNextSibling();
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getCurrentNode() {
        return this.zzav;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this;
    }
}

