/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CellFormat;
import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphCollection;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.Row;
import com.aspose.words.TableCollection;
import com.aspose.words.TableStyle;
import com.aspose.words.internal.zzZP5;
import com.aspose.words.zzPr;
import com.aspose.words.zzSI;
import com.aspose.words.zzWv0;
import com.aspose.words.zzXHl;
import com.aspose.words.zzXbZ;
import com.aspose.words.zzXkU;
import com.aspose.words.zzYOU;
import com.aspose.words.zzYeK;
import com.aspose.words.zzZJo;
import com.aspose.words.zzZoq;

public class Cell
extends CompositeNode<Node>
implements zzPr,
zzZoq {
    private zzYOU zzVOI;
    private CellFormat zzWHA;
    private ParagraphCollection zzWG4;
    private TableCollection zz1I;

    public Cell(DocumentBase doc) {
        this(doc, new zzYOU());
    }

    Cell(DocumentBase doc, zzYOU cellPr) {
        super(doc);
        this.zzVOI = cellPr;
    }

    @Override
    public int getNodeType() {
        return 7;
    }

    final Cell zzX5() {
        return (Cell)this.zzCt();
    }

    public Row getParentRow() {
        return (Row)this.zziP();
    }

    public Paragraph getFirstParagraph() {
        return (Paragraph)this.getChild(8, 0, false);
    }

    public Paragraph getLastParagraph() {
        return (Paragraph)this.getChild(8, -1, false);
    }

    public boolean isFirstCell() {
        if (this.getParentRow() != null) {
            Cell cell = this;
            if (cell == cell.getParentRow().getFirstCell()) {
                return true;
            }
        }
        return false;
    }

    public boolean isLastCell() {
        if (this.getParentRow() != null) {
            Cell cell = this;
            if (cell == cell.getParentRow().getLastCell()) {
                return true;
            }
        }
        return false;
    }

    final int zzZ22() {
        Row row = this.getParentRow();
        if (row != null) {
            return row.zzZON(this, true);
        }
        return -1;
    }

    final int zzWsi() {
        if (this.getParentRow() != null) {
            return this.getParentRow().zzWsi();
        }
        return -1;
    }

    public CellFormat getCellFormat() {
        if (this.zzWHA == null) {
            this.zzWHA = new CellFormat(this);
        }
        return this.zzWHA;
    }

    public ParagraphCollection getParagraphs() {
        if (this.zzWG4 == null) {
            this.zzWG4 = new ParagraphCollection(this);
        }
        return this.zzWG4;
    }

    public TableCollection getTables() {
        if (this.zz1I == null) {
            this.zz1I = new TableCollection(this);
        }
        return this.zz1I;
    }

    final zzYOU zzYN5() {
        return this.zzVOI;
    }

    final void zzWBj(zzYOU zzYOU2) {
        this.zzVOI = zzYOU2;
    }

    @Override
    final Node zzWBj(boolean bl, zzXkU zzXkU2) {
        zzYOU zzYOU2;
        Cell cell = (Cell)super.zzWBj(bl, zzXkU2);
        zzYOU zzYOU3 = this.zzVOI;
        cell.zzVOI = zzYOU2 = (zzYOU)zzYOU3.zzWlR();
        cell.zzWHA = null;
        cell.zzWG4 = null;
        cell.zz1I = null;
        return cell;
    }

    @Override
    public boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    final int zzWBj(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitCellStart(this);
    }

    @Override
    final int zzYxS(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitCellEnd(this);
    }

    public void ensureMinimum() {
        zzSI.zzus(this);
    }

    @Override
    final boolean zzX6s(Node node) {
        return zzXbZ.zzMS(node);
    }

    final int zzY2U() {
        Row row = this.getParentRow();
        if (row == null) {
            return -1;
        }
        int n = -1;
        Cell cell = row.getFirstCell();
        while (cell != null) {
            if (cell.getCellFormat().getHorizontalMerge() != 2) {
                ++n;
            }
            if (cell == this) {
                return n;
            }
            Cell cell2 = cell;
            cell = (Cell)cell2.zzCt();
        }
        return -1;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zzVOI.zzXte(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        Object object = this.zzVOI.zzXte(key);
        if (object == null) {
            return this.fetchInheritedCellAttr(key);
        }
        zzYeK zzYeK2 = zzZP5.zzWBj(object, zzYeK.class);
        if (zzYeK2 != null && zzYeK2.isInheritedComplexAttr()) {
            return this.fetchInheritedCellAttr(key);
        }
        return object;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        Object object = this.zzWAm(key);
        if (object != null) {
            return object;
        }
        if (this.getParentRow() != null) {
            Row row = this.getParentRow();
            switch (key) {
                case 3070: {
                    return row.fetchRowAttr(4300);
                }
                case 3090: {
                    return row.fetchRowAttr(4020);
                }
                case 3080: {
                    return row.fetchRowAttr(4310);
                }
                case 3100: {
                    return row.fetchRowAttr(4320);
                }
                case 3110: {
                    return row.fetchRowAttr(this.getParentRow().isFirstRow() ? 4050 : 4090);
                }
                case 3120: {
                    return row.fetchRowAttr(this.isFirstCell() ? 4060 : 4100);
                }
                case 3130: {
                    return row.fetchRowAttr(this.getParentRow().isLastRow() ? 4070 : 4090);
                }
                case 3140: {
                    return row.fetchRowAttr(this.isLastCell() ? 4080 : 4100);
                }
            }
        }
        return zzYOU.zzXop(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        this.zzVOI.zzZEp(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zzVOI.clear();
    }

    private Object zzWAm(int n) {
        Cell cell;
        if (this.getParentRow() == null || (cell = this).getParentRow().getParentTable() == null) {
            return null;
        }
        cell = this;
        TableStyle tableStyle = zzZP5.zzWBj((Object)cell.getParentRow().getParentTable().getStyle(), TableStyle.class);
        if (tableStyle != null) {
            return tableStyle.zzWBj(n, this);
        }
        return null;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzXHl getInsertRevision() {
        Cell cell = this;
        return cell.zzVOI.getInsertRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setInsertRevision(zzXHl value) {
        zzZoq zzZoq2 = this;
        zzXHl zzXHl2 = value;
        zzZoq2 = zzZoq2.zzVOI;
        ((zzZJo)((Object)zzZoq2)).zzZEp(14, zzXHl2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzXHl getDeleteRevision() {
        Cell cell = this;
        return cell.zzVOI.getDeleteRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setDeleteRevision(zzXHl value) {
        zzZoq zzZoq2 = this;
        zzXHl zzXHl2 = value;
        zzZoq2 = zzZoq2.zzVOI;
        ((zzZJo)((Object)zzZoq2)).zzZEp(12, zzXHl2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzWv0 getMoveFromRevision() {
        Cell cell = this;
        return cell.zzVOI.getMoveFromRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveFromRevision(zzWv0 value) {
        zzZoq zzZoq2 = this;
        zzWv0 zzWv02 = value;
        zzZoq2 = zzZoq2.zzVOI;
        ((zzZJo)((Object)zzZoq2)).zzZEp(13, zzWv02);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzWv0 getMoveToRevision() {
        Cell cell = this;
        return cell.zzVOI.getMoveToRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveToRevision(zzWv0 value) {
        zzZoq zzZoq2 = this;
        zzWv0 zzWv02 = value;
        zzZoq2 = zzZoq2.zzVOI;
        ((zzZJo)((Object)zzZoq2)).zzZEp(15, zzWv02);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeMoveRevisions() {
        Cell cell = this;
        cell.zzVOI.remove(13);
        cell = this;
        cell.zzVOI.remove(15);
    }

    final zzYOU zzW1X(boolean bl) {
        Cell cell;
        TableStyle tableStyle;
        zzYOU zzYOU2 = new zzYOU();
        this.zzWBj(3120, zzYOU2);
        this.zzWBj(3140, zzYOU2);
        this.zzWBj(3110, zzYOU2);
        this.zzWBj(3130, zzYOU2);
        this.zzWBj(3090, zzYOU2);
        this.zzWBj(3100, zzYOU2);
        this.zzWBj(3070, zzYOU2);
        this.zzWBj(3080, zzYOU2);
        if (bl && (tableStyle = zzZP5.zzWBj((Object)(cell = this).getParentRow().getParentTable().getStyle(), TableStyle.class)) != null) {
            tableStyle.zzYxS(this, zzYOU2);
        }
        this.zzVOI.zzYxS((zzZJo)zzYOU2);
        return zzYOU2;
    }

    private void zzWBj(int n, zzYOU zzYOU2) {
        zzYOU2.zzZEp(n, this.fetchInheritedCellAttr(n));
    }
}

