/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Border;
import com.aspose.words.internal.zzXLp;
import com.aspose.words.internal.zzZP5;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzEp;
import java.awt.Color;
import java.util.Iterator;

public final class BorderCollection
implements Iterable<Border> {
    private zzEp zzWAZ;

    BorderCollection(zzEp parent) {
        this.zzWAZ = parent;
    }

    public final boolean equals(BorderCollection brColl) throws Exception {
        if (zzZP5.zzZnb(this, brColl)) {
            return true;
        }
        return this.getLeft().equals(brColl.getLeft()) && this.getRight().equals(brColl.getRight()) && this.getTop().equals(brColl.getTop()) && this.getBottom().equals(brColl.getBottom()) && this.getHorizontal().equals(brColl.getHorizontal()) && this.getVertical().equals(brColl.getVertical()) && this.getColor().equals(brColl.getColor()) && this.zzZ2Z().equals(brColl.zzZ2Z()) && this.getDistanceFromText() == brColl.getDistanceFromText() && this.getLineWidth() == brColl.getLineWidth() && this.getLineStyle() == brColl.getLineStyle() && this.getCount() == brColl.getCount() && this.getShadow() == brColl.getShadow() && this.isVisible() == brColl.isVisible();
    }

    public final Border getByBorderType(int borderType) throws Exception {
        RefInt refInt = new RefInt(0);
        boolean bl = !this.zzWAZ.getPossibleBorderKeys().zzWBj(borderType, refInt);
        int borderKey = refInt.get();
        if (bl) {
            throw new IllegalStateException("The requested border is not available for this object.");
        }
        Border border = (Border)this.zzWAZ.getDirectBorderAttr(borderKey);
        if (border == null) {
            border = new Border(this.zzWAZ, borderKey);
            this.zzWAZ.setBorderAttr(borderKey, border);
        }
        return border;
    }

    public final Border get(int index) throws Exception {
        int n = this.zzWAZ.getPossibleBorderKeys().zzaD().get(index);
        return this.getByBorderType(n);
    }

    public final Border getLeft() throws Exception {
        return this.getByBorderType(1);
    }

    public final Border getRight() throws Exception {
        return this.getByBorderType(2);
    }

    public final Border getTop() throws Exception {
        return this.getByBorderType(3);
    }

    public final Border getBottom() throws Exception {
        return this.getByBorderType(0);
    }

    public final Border getHorizontal() throws Exception {
        return this.getByBorderType(4);
    }

    public final Border getVertical() throws Exception {
        return this.getByBorderType(5);
    }

    public final int getCount() {
        return this.zzWAZ.getPossibleBorderKeys().getCount();
    }

    public final double getLineWidth() throws Exception {
        return this.get(0).getLineWidth();
    }

    public final void setLineWidth(double value) throws Exception {
        Iterator iterator = this.zzWAZ.getPossibleBorderKeys().zzaD().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzY0x(n)) continue;
            this.getByBorderType(n).setLineWidth(value);
        }
    }

    public final int getLineStyle() throws Exception {
        return this.get(0).getLineStyle();
    }

    public final void setLineStyle(int value) throws Exception {
        Iterator iterator = this.zzWAZ.getPossibleBorderKeys().zzaD().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzY0x(n)) continue;
            this.getByBorderType(n).setLineStyle(value);
        }
    }

    public final Color getColor() throws Exception {
        return this.zzZ2Z().zzXnj();
    }

    public final void setColor(Color value) throws Exception {
        this.zzXHW(zzXLp.zzYxS(value));
    }

    private zzXLp zzZ2Z() throws Exception {
        return this.get(0).zzZ2Z();
    }

    private void zzXHW(zzXLp zzXLp2) throws Exception {
        Iterator iterator = this.zzWAZ.getPossibleBorderKeys().zzaD().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzY0x(n)) continue;
            this.getByBorderType(n).zzXHW(zzXLp2);
        }
    }

    public final double getDistanceFromText() throws Exception {
        return this.get(0).getDistanceFromText();
    }

    public final void setDistanceFromText(double value) throws Exception {
        Iterator iterator = this.zzWAZ.getPossibleBorderKeys().zzaD().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzY0x(n)) continue;
            this.getByBorderType(n).setDistanceFromText(value);
        }
    }

    public final boolean getShadow() throws Exception {
        return this.get(0).getShadow();
    }

    public final void setShadow(boolean value) throws Exception {
        Iterator iterator = this.zzWAZ.getPossibleBorderKeys().zzaD().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzY0x(n)) continue;
            this.getByBorderType(n).setShadow(value);
        }
    }

    public final void clearFormatting() {
        for (Border border : this) {
            border.clearFormatting();
        }
    }

    @Override
    public final Iterator<Border> iterator() {
        return new zzWBj(this);
    }

    final boolean isVisible() {
        for (Border border : this) {
            if (!border.isVisible()) continue;
            return true;
        }
        return false;
    }

    private static boolean zzY0x(int n) {
        return n != 6 && n != 7;
    }

    static final class zzWBj
    implements Iterator<Border> {
        private BorderCollection zzXeC;
        private int zzXN8;

        zzWBj(BorderCollection borderCollection) {
            this.zzXeC = borderCollection;
            this.zzXN8 = -1;
        }

        @Override
        public final boolean hasNext() {
            if (this.zzXN8 >= this.zzXeC.getCount() - 1) {
                return false;
            }
            ++this.zzXN8;
            return true;
        }

        private Border zzWcI() {
            try {
                return this.zzXeC.get(this.zzXN8);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final /* synthetic */ Object next() {
            return this.zzWcI();
        }
    }
}

