/*
 * Decompiled with CFR 0.152.
 */
package com.artofsolving.jodconverter.openoffice.converter;

import com.artofsolving.jodconverter.DocumentFormat;
import com.artofsolving.jodconverter.DocumentFormatRegistry;
import com.artofsolving.jodconverter.openoffice.connection.OpenOfficeConnection;
import com.artofsolving.jodconverter.openoffice.connection.OpenOfficeException;
import com.artofsolving.jodconverter.openoffice.converter.AbstractOpenOfficeDocumentConverter;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XStorable;
import com.sun.star.lang.XComponent;
import com.sun.star.ucb.XFileIdentifierConverter;
import com.sun.star.uno.UnoRuntime;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class OpenOfficeDocumentConverter
extends AbstractOpenOfficeDocumentConverter {
    static /* synthetic */ Class class$0;

    public OpenOfficeDocumentConverter(OpenOfficeConnection connection) {
        super(connection);
    }

    public OpenOfficeDocumentConverter(OpenOfficeConnection connection, DocumentFormatRegistry formatRegistry) {
        super(connection, formatRegistry);
    }

    protected void convertInternal(InputStream inputStream, DocumentFormat inputFormat, OutputStream outputStream, DocumentFormat outputFormat) {
        File inputFile = null;
        File outputFile = null;
        try {
            try {
                inputFile = File.createTempFile("document", "." + inputFormat.getFileExtension());
                FileOutputStream inputFileStream = null;
                try {
                    inputFileStream = new FileOutputStream(inputFile);
                    IOUtils.copy((InputStream)inputStream, (OutputStream)inputFileStream);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(inputFileStream);
                    throw throwable;
                }
                IOUtils.closeQuietly((OutputStream)inputFileStream);
                outputFile = File.createTempFile("document", "." + outputFormat.getFileExtension());
                this.convert(inputFile, inputFormat, outputFile, outputFormat);
                FileInputStream outputFileStream = null;
                try {
                    outputFileStream = new FileInputStream(outputFile);
                    IOUtils.copy((InputStream)outputFileStream, (OutputStream)outputStream);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(outputFileStream);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)outputFileStream);
            }
            catch (IOException ioException) {
                throw new OpenOfficeException("conversion failed", ioException);
            }
        }
        finally {
            if (inputFile != null) {
                inputFile.delete();
            }
            if (outputFile != null) {
                outputFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void convertInternal(File inputFile, DocumentFormat inputFormat, File outputFile, DocumentFormat outputFormat) {
        HashMap loadProperties = new HashMap();
        loadProperties.putAll(this.getDefaultLoadProperties());
        loadProperties.putAll(inputFormat.getImportOptions());
        Map storeProperties = outputFormat.getExportOptions(inputFormat.getFamily());
        OpenOfficeConnection openOfficeConnection = this.openOfficeConnection;
        synchronized (openOfficeConnection) {
            XFileIdentifierConverter fileContentProvider = this.openOfficeConnection.getFileContentProvider();
            String inputUrl = fileContentProvider.getFileURLFromSystemPath("", inputFile.getAbsolutePath());
            String outputUrl = fileContentProvider.getFileURLFromSystemPath("", outputFile.getAbsolutePath());
            try {
                this.loadAndExport(inputUrl, loadProperties, outputUrl, storeProperties);
            }
            catch (OpenOfficeException openOfficeException) {
                throw openOfficeException;
            }
            catch (Throwable throwable) {
                throw new OpenOfficeException("conversion failed", throwable);
            }
        }
    }

    private void loadAndExport(String inputUrl, Map loadProperties, String outputUrl, Map storeProperties) throws Exception {
        XComponentLoader desktop = this.openOfficeConnection.getDesktop();
        XComponent document = desktop.loadComponentFromURL(inputUrl, "_blank", 0, OpenOfficeDocumentConverter.toPropertyValues(loadProperties));
        if (document == null) {
            throw new OpenOfficeException("conversion failed: input document is null after loading");
        }
        this.refreshDocument(document);
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.sun.star.frame.XStorable");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            XStorable storable = (XStorable)UnoRuntime.queryInterface((Class)clazz, (Object)document);
            storable.storeToURL(outputUrl, OpenOfficeDocumentConverter.toPropertyValues(storeProperties));
        }
        finally {
            document.dispose();
        }
    }
}

