/*
 * Decompiled with CFR 0.152.
 */
package com.artofsolving.jodconverter.openoffice.connection;

import com.artofsolving.jodconverter.openoffice.connection.OpenOfficeConnection;
import com.artofsolving.jodconverter.openoffice.connection.OpenOfficeException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.bridge.XBridge;
import com.sun.star.bridge.XBridgeFactory;
import com.sun.star.comp.helper.Bootstrap;
import com.sun.star.connection.NoConnectException;
import com.sun.star.connection.XConnection;
import com.sun.star.connection.XConnector;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XEventListener;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.ucb.XFileIdentifierConverter;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.net.ConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOpenOfficeConnection
implements OpenOfficeConnection,
XEventListener {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String connectionString;
    private XComponent bridgeComponent;
    private XMultiComponentFactory serviceManager;
    private XComponentContext componentContext;
    private boolean connected = false;
    private boolean expectingDisconnection = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;

    protected AbstractOpenOfficeConnection(String connectionString) {
        this.connectionString = connectionString;
    }

    public synchronized void connect() throws ConnectException {
        this.logger.debug("connecting");
        try {
            XComponentContext localContext = Bootstrap.createInitialComponentContext(null);
            XMultiComponentFactory localServiceManager = localContext.getServiceManager();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.sun.star.connection.XConnector");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            XConnector connector = (XConnector)UnoRuntime.queryInterface(clazz, (Object)localServiceManager.createInstanceWithContext("com.sun.star.connection.Connector", localContext));
            XConnection connection = connector.connect(this.connectionString);
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("com.sun.star.bridge.XBridgeFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            XBridgeFactory bridgeFactory = (XBridgeFactory)UnoRuntime.queryInterface(clazz2, (Object)localServiceManager.createInstanceWithContext("com.sun.star.bridge.BridgeFactory", localContext));
            XBridge bridge = bridgeFactory.createBridge("", "urp", connection, null);
            Class<?> clazz3 = class$2;
            if (clazz3 == null) {
                try {
                    clazz3 = class$2 = Class.forName("com.sun.star.lang.XComponent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.bridgeComponent = (XComponent)UnoRuntime.queryInterface((Class)clazz3, (Object)bridge);
            this.bridgeComponent.addEventListener((XEventListener)this);
            Class<?> clazz4 = class$3;
            if (clazz4 == null) {
                try {
                    clazz4 = class$3 = Class.forName("com.sun.star.lang.XMultiComponentFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.serviceManager = (XMultiComponentFactory)UnoRuntime.queryInterface((Class)clazz4, (Object)bridge.getInstance("StarOffice.ServiceManager"));
            Class<?> clazz5 = class$4;
            if (clazz5 == null) {
                try {
                    clazz5 = class$4 = Class.forName("com.sun.star.beans.XPropertySet");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            XPropertySet properties = (XPropertySet)UnoRuntime.queryInterface((Class)clazz5, (Object)this.serviceManager);
            Class<?> clazz6 = class$5;
            if (clazz6 == null) {
                try {
                    clazz6 = class$5 = Class.forName("com.sun.star.uno.XComponentContext");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.componentContext = (XComponentContext)UnoRuntime.queryInterface((Class)clazz6, (Object)properties.getPropertyValue("DefaultContext"));
            this.connected = true;
            this.logger.info("connected");
        }
        catch (NoConnectException connectException) {
            throw new ConnectException("connection failed: " + this.connectionString + ": " + connectException.getMessage());
        }
        catch (Exception exception) {
            throw new OpenOfficeException("connection failed: " + this.connectionString, exception);
        }
    }

    public synchronized void disconnect() {
        this.logger.debug("disconnecting");
        this.expectingDisconnection = true;
        this.bridgeComponent.dispose();
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void disposing(EventObject event) {
        this.connected = false;
        if (this.expectingDisconnection) {
            this.logger.info("disconnected");
        } else {
            this.logger.error("disconnected unexpectedly");
        }
        this.expectingDisconnection = false;
    }

    void simulateUnexpectedDisconnection() {
        this.disposing(null);
        this.bridgeComponent.dispose();
    }

    private Object getService(String className) {
        try {
            if (!this.connected) {
                this.logger.info("trying to (re)connect");
                this.connect();
            }
            return this.serviceManager.createInstanceWithContext(className, this.componentContext);
        }
        catch (Exception exception) {
            throw new OpenOfficeException("could not obtain service: " + className, exception);
        }
    }

    public XComponentLoader getDesktop() {
        Class<?> clazz = class$6;
        if (clazz == null) {
            try {
                clazz = class$6 = Class.forName("com.sun.star.frame.XComponentLoader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (XComponentLoader)UnoRuntime.queryInterface((Class)clazz, (Object)this.getService("com.sun.star.frame.Desktop"));
    }

    public XFileIdentifierConverter getFileContentProvider() {
        Class<?> clazz = class$7;
        if (clazz == null) {
            try {
                clazz = class$7 = Class.forName("com.sun.star.ucb.XFileIdentifierConverter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (XFileIdentifierConverter)UnoRuntime.queryInterface((Class)clazz, (Object)this.getService("com.sun.star.ucb.FileContentProvider"));
    }
}

