/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.tracer.plugins.springmvc;

import com.alipay.common.tracer.core.appender.encoder.SpanEncoder;
import com.alipay.common.tracer.core.configuration.SofaTracerConfiguration;
import com.alipay.common.tracer.core.reporter.stat.AbstractSofaTracerStatisticReporter;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import com.alipay.common.tracer.core.tracer.AbstractServerTracer;
import com.alipay.sofa.tracer.plugins.springmvc.SpringMvcDigestEncoder;
import com.alipay.sofa.tracer.plugins.springmvc.SpringMvcDigestJsonEncoder;
import com.alipay.sofa.tracer.plugins.springmvc.SpringMvcJsonStatReporter;
import com.alipay.sofa.tracer.plugins.springmvc.SpringMvcLogEnum;
import com.alipay.sofa.tracer.plugins.springmvc.SpringMvcStatReporter;

public class SpringMvcTracer
extends AbstractServerTracer {
    private static volatile SpringMvcTracer springMvcTracer = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SpringMvcTracer getSpringMvcTracerSingleton() {
        if (springMvcTracer != null) return springMvcTracer;
        Class<SpringMvcTracer> clazz = SpringMvcTracer.class;
        synchronized (SpringMvcTracer.class) {
            if (springMvcTracer != null) return springMvcTracer;
            springMvcTracer = new SpringMvcTracer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return springMvcTracer;
        }
    }

    private SpringMvcTracer() {
        super("springmvc");
    }

    protected String getServerDigestReporterLogName() {
        return SpringMvcLogEnum.SPRING_MVC_DIGEST.getDefaultLogName();
    }

    protected String getServerDigestReporterRollingKey() {
        return SpringMvcLogEnum.SPRING_MVC_DIGEST.getRollingKey();
    }

    protected String getServerDigestReporterLogNameKey() {
        return SpringMvcLogEnum.SPRING_MVC_DIGEST.getLogNameKey();
    }

    protected SpanEncoder<SofaTracerSpan> getServerDigestEncoder() {
        if (SofaTracerConfiguration.isJsonOutput()) {
            return new SpringMvcDigestJsonEncoder();
        }
        return new SpringMvcDigestEncoder();
    }

    protected AbstractSofaTracerStatisticReporter generateServerStatReporter() {
        return this.generateSofaMvcStatReporter();
    }

    private SpringMvcStatReporter generateSofaMvcStatReporter() {
        SpringMvcLogEnum springMvcLogEnum = SpringMvcLogEnum.SPRING_MVC_STAT;
        String statLog = springMvcLogEnum.getDefaultLogName();
        String statRollingPolicy = SofaTracerConfiguration.getRollingPolicy((String)springMvcLogEnum.getRollingKey());
        String statLogReserveConfig = SofaTracerConfiguration.getLogReserveConfig((String)springMvcLogEnum.getLogNameKey());
        if (SofaTracerConfiguration.isJsonOutput()) {
            return new SpringMvcJsonStatReporter(statLog, statRollingPolicy, statLogReserveConfig);
        }
        return new SpringMvcStatReporter(statLog, statRollingPolicy, statLogReserveConfig);
    }
}

