/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.tracer.plugins.springcloud.tracers;

import com.alipay.common.tracer.core.appender.encoder.SpanEncoder;
import com.alipay.common.tracer.core.configuration.SofaTracerConfiguration;
import com.alipay.common.tracer.core.reporter.stat.AbstractSofaTracerStatisticReporter;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import com.alipay.common.tracer.core.tracer.AbstractClientTracer;
import com.alipay.sofa.tracer.plugins.springcloud.encodes.OpenFeignDigestEncoder;
import com.alipay.sofa.tracer.plugins.springcloud.encodes.OpenFeignDigestJsonEncoder;
import com.alipay.sofa.tracer.plugins.springcloud.enums.FeignClientLogEnum;
import com.alipay.sofa.tracer.plugins.springcloud.repoters.OpenFeignStatJsonReporter;
import com.alipay.sofa.tracer.plugins.springcloud.repoters.OpenFeignStatReporter;

public class FeignClientTracer
extends AbstractClientTracer {
    private static volatile FeignClientTracer feignClientTracer = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FeignClientTracer getFeignClientTracerSingleton() {
        if (feignClientTracer != null) return feignClientTracer;
        Class<FeignClientTracer> clazz = FeignClientTracer.class;
        synchronized (FeignClientTracer.class) {
            if (feignClientTracer != null) return feignClientTracer;
            feignClientTracer = new FeignClientTracer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return feignClientTracer;
        }
    }

    protected FeignClientTracer() {
        super("open-feign");
    }

    protected String getClientDigestReporterLogName() {
        return FeignClientLogEnum.FEIGN_CLIENT_DIGEST.getDefaultLogName();
    }

    protected String getClientDigestReporterRollingKey() {
        return FeignClientLogEnum.FEIGN_CLIENT_DIGEST.getRollingKey();
    }

    protected String getClientDigestReporterLogNameKey() {
        return FeignClientLogEnum.FEIGN_CLIENT_DIGEST.getLogNameKey();
    }

    protected SpanEncoder<SofaTracerSpan> getClientDigestEncoder() {
        if (SofaTracerConfiguration.isJsonOutput()) {
            return new OpenFeignDigestJsonEncoder();
        }
        return new OpenFeignDigestEncoder();
    }

    protected AbstractSofaTracerStatisticReporter generateClientStatReporter() {
        FeignClientLogEnum feignClientLogEnum = FeignClientLogEnum.FEIGN_CLIENT_STAT;
        String statLog = feignClientLogEnum.getDefaultLogName();
        String statRollingPolicy = SofaTracerConfiguration.getRollingPolicy((String)feignClientLogEnum.getRollingKey());
        String statLogReserveConfig = SofaTracerConfiguration.getLogReserveConfig((String)feignClientLogEnum.getLogNameKey());
        return this.getOpenFeignStatJsonReporter(statLog, statRollingPolicy, statLogReserveConfig);
    }

    protected AbstractSofaTracerStatisticReporter getOpenFeignStatJsonReporter(String statTracerName, String statRollingPolicy, String statLogReserveConfig) {
        if (SofaTracerConfiguration.isJsonOutput()) {
            return new OpenFeignStatJsonReporter(statTracerName, statRollingPolicy, statLogReserveConfig);
        }
        return new OpenFeignStatReporter(statTracerName, statRollingPolicy, statLogReserveConfig);
    }
}

