/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.tracer.plugins.springcloud.instruments.feign;

import com.alipay.common.tracer.core.SofaTracer;
import com.alipay.common.tracer.core.appender.self.SelfLog;
import com.alipay.common.tracer.core.configuration.SofaTracerConfiguration;
import com.alipay.common.tracer.core.registry.ExtendFormat;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import com.alipay.sofa.tracer.plugins.springcloud.carriers.FeignRequestCarrier;
import com.alipay.sofa.tracer.plugins.springcloud.tracers.FeignClientTracer;
import feign.Client;
import feign.Request;
import feign.Response;
import io.opentracing.SpanContext;
import io.opentracing.tag.Tags;
import java.net.MalformedURLException;
import java.net.URL;

public class SofaTracerFeignClient
implements Client {
    private Client delegate;
    private FeignClientTracer feignClientTracer;

    public SofaTracerFeignClient(Client delegate) {
        this.delegate = delegate;
    }

    public Response execute(Request request, Request.Options options) {
        if (this.feignClientTracer == null) {
            this.feignClientTracer = FeignClientTracer.getFeignClientTracerSingleton();
        }
        SofaTracerSpan sofaTracerSpan = null;
        int resultCode = -1;
        try {
            sofaTracerSpan = this.feignClientTracer.clientSend(request.method());
            this.appendRequestSpanTagsAndInject(request, sofaTracerSpan);
            Response response = this.delegate.execute(request, options);
            this.appendResponseSpanTags(response, sofaTracerSpan);
            resultCode = response.status();
            Response response2 = response;
            return response2;
        }
        catch (Exception ex) {
            this.appendExceptionSpanTags(request, sofaTracerSpan, ex);
            throw new RuntimeException(ex);
        }
        finally {
            if (sofaTracerSpan != null) {
                this.feignClientTracer.clientReceive(String.valueOf(resultCode));
            }
        }
    }

    private void appendExceptionSpanTags(Request request, SofaTracerSpan sofaTracerSpan, Exception ex) {
        this.appendRequestSpanTags(request, sofaTracerSpan);
        sofaTracerSpan.setTag("result.code", (Number)-1);
        sofaTracerSpan.setTag(Tags.ERROR.getKey(), ex.getMessage());
    }

    private String[] parseRemoteHostAndPort(Request request) {
        String[] hostWithPort = new String[2];
        URL requestUrl = null;
        try {
            requestUrl = new URL(request.url());
        }
        catch (MalformedURLException e) {
            SelfLog.error((String)("cannot parse remote host and port. request:" + request.url()), (Throwable)e);
        }
        hostWithPort[0] = requestUrl != null ? requestUrl.getHost() : "";
        hostWithPort[1] = String.valueOf(requestUrl != null ? requestUrl.getPort() : -1);
        return hostWithPort;
    }

    private void appendResponseSpanTags(Response response, SofaTracerSpan sofaTracerSpan) {
        if (sofaTracerSpan == null) {
            return;
        }
        sofaTracerSpan.setTag("resp.size.bytes", (Number)response.body().length());
        sofaTracerSpan.setTag("current.thread.name", Thread.currentThread().getName());
        sofaTracerSpan.setTag("result.code", (Number)response.status());
    }

    private void appendRequestSpanTagsAndInject(Request request, SofaTracerSpan sofaTracerSpan) {
        this.appendRequestSpanTags(request, sofaTracerSpan);
        this.injectCarrier(request, sofaTracerSpan);
    }

    private void appendRequestSpanTags(Request request, SofaTracerSpan sofaTracerSpan) {
        if (sofaTracerSpan == null) {
            return;
        }
        String appName = SofaTracerConfiguration.getProperty((String)"spring.application.name", (String)"");
        String methodName = request.method();
        sofaTracerSpan.setTag("local.app", appName == null ? "" : appName);
        sofaTracerSpan.setTag(Tags.SPAN_KIND.getKey(), "client");
        sofaTracerSpan.setTag("remote.app", "");
        sofaTracerSpan.setTag("request.url", request.url());
        sofaTracerSpan.setTag("method", methodName);
        String[] hostWithPort = this.parseRemoteHostAndPort(request);
        sofaTracerSpan.setTag("remote.host", hostWithPort[0]);
        sofaTracerSpan.setTag("remote.port", hostWithPort[1]);
        if (request.body() != null) {
            sofaTracerSpan.setTag("req.size.bytes", (Number)request.body().length);
        } else {
            sofaTracerSpan.setTag("req.size.bytes", (Number)0);
        }
    }

    private void injectCarrier(Object request, SofaTracerSpan currentSpan) {
        if (request instanceof Request) {
            SofaTracer sofaTracer = this.feignClientTracer.getSofaTracer();
            sofaTracer.inject((SpanContext)currentSpan.getSofaTracerSpanContext(), ExtendFormat.Builtin.B3_HTTP_HEADERS, (Object)new FeignRequestCarrier((Request)request));
        }
    }
}

