/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.autoconfigure.tracer;

import com.alipay.common.tracer.core.listener.SpanReportListener;
import com.alipay.common.tracer.core.listener.SpanReportListenerHolder;
import com.alipay.common.tracer.core.reporter.facade.Reporter;
import com.alipay.common.tracer.core.samplers.Sampler;
import com.alipay.common.tracer.core.samplers.SamplerFactory;
import com.alipay.common.tracer.core.utils.StringUtils;
import com.alipay.sofa.tracer.boot.properties.SofaTracerProperties;
import com.alipay.sofa.tracer.plugin.flexible.FlexibleTracer;
import io.opentracing.Tracer;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={SofaTracerProperties.class})
@ConditionalOnClass(value={SpanReportListenerHolder.class, Tracer.class, SofaTracerProperties.class, FlexibleTracer.class})
public class SofaTracerAutoConfiguration {
    @Autowired(required=false)
    private List<SpanReportListener> spanReportListenerList;

    @Bean
    @ConditionalOnMissingBean
    public SpanReportListenerHolder sofaTracerSpanReportListener() {
        if (this.spanReportListenerList != null && this.spanReportListenerList.size() > 0) {
            SpanReportListenerHolder.addSpanReportListeners(this.spanReportListenerList);
        }
        return null;
    }

    @Bean
    @ConditionalOnMissingBean
    public Tracer tracer(SofaTracerProperties sofaTracerProperties) throws Exception {
        String reporterName = sofaTracerProperties.getReporterName();
        if (StringUtils.isNotBlank((String)reporterName)) {
            Reporter reporter = (Reporter)Class.forName(reporterName).newInstance();
            Sampler sampler = SamplerFactory.getSampler();
            return new FlexibleTracer(sampler, reporter);
        }
        FlexibleTracer tracer = new FlexibleTracer();
        return tracer;
    }
}

