/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.actuator.version;

import com.alipay.sofa.boot.log.InfraLoggerFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.util.Assert;

@Endpoint(id="versions")
public class SofaBootVersionEndpoint {
    private Logger logger = InfraLoggerFactory.getLogger(SofaBootVersionEndpoint.class);
    private List<Object> endpointResult = new ArrayList<Object>();
    private PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();

    @ReadOperation
    public List<Object> versions() {
        if (this.endpointResult.isEmpty()) {
            try {
                this.endpointResult = Stream.of(this.resourcePatternResolver.getResources("classpath*:META-INF/sofa.versions.properties")).map(this::loadProperties).collect(Collectors.toList());
            }
            catch (Exception ex) {
                this.logger.warn("Load properties failed: {}", (Object)ex.getMessage());
            }
        }
        return this.endpointResult;
    }

    private Properties loadProperties(Resource resourceLocation) {
        Assert.notNull((Object)resourceLocation, (String)"Properties resource location must not be null.");
        this.logger.info("Loading properties file from {}", (Object)resourceLocation);
        Properties result = new Properties();
        try {
            PropertiesLoaderUtils.fillProperties((Properties)result, (EncodedResource)new EncodedResource(resourceLocation));
        }
        catch (IOException ex) {
            this.logger.warn("Error occurred when loading properties from {}: {}", (Object)resourceLocation, (Object)ex.getMessage());
        }
        return result;
    }
}

