/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.healthcheck.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.core.OrderComparator;

public class HealthCheckUtils {
    public static <T, U> LinkedHashMap<T, U> sortMapAccordingToValue(Map<T, U> origin, BeanFactory beanFactory) {
        Comparator comparatorToUse = null;
        if (beanFactory instanceof DefaultListableBeanFactory) {
            comparatorToUse = ((DefaultListableBeanFactory)beanFactory).getDependencyComparator();
        }
        if (comparatorToUse == null) {
            comparatorToUse = OrderComparator.INSTANCE;
        }
        Comparator finalComparator = comparatorToUse;
        ArrayList<Map.Entry<T, U>> entryList = new ArrayList<Map.Entry<T, U>>(origin.entrySet());
        Collections.sort(entryList, (o1, o2) -> finalComparator.compare(o1.getValue(), o2.getValue()));
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : entryList) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }
}

