/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.healthcheck;

import com.alipay.sofa.boot.util.BinaryOperators;
import com.alipay.sofa.healthcheck.log.HealthCheckLoggerFactory;
import com.alipay.sofa.healthcheck.startup.ReadinessCheckCallback;
import com.alipay.sofa.healthcheck.util.HealthCheckUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;

public class AfterReadinessCheckCallbackProcessor {
    private static Logger logger = HealthCheckLoggerFactory.getLogger(AfterReadinessCheckCallbackProcessor.class);
    private ObjectMapper objectMapper = new ObjectMapper();
    private AtomicBoolean isInitiated = new AtomicBoolean(false);
    @Autowired
    private ApplicationContext applicationContext;
    private LinkedHashMap<String, ReadinessCheckCallback> readinessCheckCallbacks = null;

    public void init() {
        if (this.isInitiated.compareAndSet(false, true)) {
            Assert.notNull((Object)this.applicationContext, () -> "Application must not be null");
            Map beansOfType = this.applicationContext.getBeansOfType(ReadinessCheckCallback.class);
            this.readinessCheckCallbacks = HealthCheckUtils.sortMapAccordingToValue(beansOfType, (BeanFactory)this.applicationContext.getAutowireCapableBeanFactory());
            StringBuilder applicationCallbackInfo = new StringBuilder(512).append("Found ").append(this.readinessCheckCallbacks.size()).append(" ReadinessCheckCallback implementation: ").append(String.join((CharSequence)",", beansOfType.keySet()));
            logger.info(applicationCallbackInfo.toString());
        }
    }

    public boolean afterReadinessCheckCallback(Map<String, Health> healthMap) {
        logger.info("Begin ReadinessCheckCallback readiness check");
        Assert.notNull(this.readinessCheckCallbacks, (String)"ReadinessCheckCallbacks must not be null.");
        boolean result = this.readinessCheckCallbacks.entrySet().stream().map(entry -> this.doHealthCheckCallback((String)entry.getKey(), (ReadinessCheckCallback)entry.getValue(), healthMap)).reduce(true, BinaryOperators.andBoolean());
        if (result) {
            logger.info("ReadinessCheckCallback readiness check result: success.");
        } else {
            logger.error("ReadinessCheckCallback readiness check result: failed.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doHealthCheckCallback(String beanId, ReadinessCheckCallback readinessCheckCallback, Map<String, Health> healthMap) {
        Assert.notNull(healthMap, () -> "HealthMap must not be null");
        boolean result = false;
        Health health = null;
        try {
            health = readinessCheckCallback.onHealthy(this.applicationContext);
            result = health.getStatus().equals((Object)Status.UP);
            if (result) {
                logger.info("SOFABoot ReadinessCheckCallback[{}] check success.", (Object)beanId);
            } else {
                logger.error("SOFABoot ReadinessCheckCallback[{}] check failed, the details is: {}.", (Object)beanId, (Object)this.objectMapper.writeValueAsString((Object)health.getDetails()));
            }
        }
        catch (Throwable t) {
            if (health == null) {
                health = new Health.Builder().down((Throwable)new RuntimeException(t)).build();
            }
            logger.error(String.format("Error occurred while doing ReadinessCheckCallback[%s] check.", beanId), t);
        }
        finally {
            healthMap.put(beanId, health);
        }
        return result;
    }
}

