/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.huggingface.translator;

import ai.djl.huggingface.tokenizers.Encoding;
import ai.djl.huggingface.tokenizers.HuggingFaceTokenizer;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.translate.Batchifier;
import ai.djl.translate.NoBatchifyTranslator;
import ai.djl.translate.TranslateException;
import ai.djl.translate.TranslatorContext;
import ai.djl.util.PairList;
import ai.djl.util.StringPair;
import java.util.Arrays;

public class CrossEncoderBatchTranslator
implements NoBatchifyTranslator<StringPair[], float[][]> {
    private HuggingFaceTokenizer tokenizer;
    private boolean includeTokenTypes;
    private Batchifier batchifier;

    CrossEncoderBatchTranslator(HuggingFaceTokenizer tokenizer, boolean includeTokenTypes, Batchifier batchifier) {
        this.tokenizer = tokenizer;
        this.includeTokenTypes = includeTokenTypes;
        this.batchifier = batchifier;
    }

    public NDList processInput(TranslatorContext ctx, StringPair[] inputs) throws TranslateException {
        NDManager manager = ctx.getNDManager();
        PairList list = new PairList(Arrays.asList(inputs));
        Encoding[] encodings = this.tokenizer.batchEncode((PairList<String, String>)list);
        NDList[] batch = new NDList[encodings.length];
        for (int i = 0; i < encodings.length; ++i) {
            batch[i] = encodings[i].toNDList(manager, this.includeTokenTypes);
        }
        return this.batchifier.batchify(batch);
    }

    public float[][] processOutput(TranslatorContext ctx, NDList list) {
        NDList[] batch = this.batchifier.unbatchify(list);
        float[][] ret = new float[batch.length][];
        for (int i = 0; i < batch.length; ++i) {
            NDArray logits = (NDArray)list.get(0);
            NDArray result = logits.getNDArrayInternal().sigmoid();
            ret[i] = result.toFloatArray();
        }
        return ret;
    }
}

